/*
 * Decompiled with CFR 0.152.
 */
package org.black_ixx.playerpoints.storage.imports;

import org.black_ixx.playerpoints.PlayerPoints;
import org.black_ixx.playerpoints.config.RootConfig;
import org.black_ixx.playerpoints.storage.StorageType;
import org.black_ixx.playerpoints.storage.imports.SQLiteImport;
import org.black_ixx.playerpoints.storage.imports.YAMLImport;

public class Importer {
    private PlayerPoints plugin;

    public Importer(PlayerPoints plugin) {
        this.plugin = plugin;
    }

    public void checkImport() {
        RootConfig config = this.plugin.getModuleForClass(RootConfig.class);
        if (config.importSQL && config.getStorageType() == StorageType.MYSQL) {
            this.importSQL(config.importSource);
            this.plugin.getConfig().set("mysql.import.use", (Object)false);
            this.plugin.saveConfig();
        }
    }

    private void importSQL(StorageType source) {
        switch (source) {
            case YAML: {
                YAMLImport yaml = new YAMLImport(this.plugin);
                yaml.doImport();
                break;
            }
            case SQLITE: {
                SQLiteImport sqlite = new SQLiteImport(this.plugin);
                sqlite.doImport();
            }
        }
    }
}

