/*
 * Decompiled with CFR 0.152.
 */
package org.black_ixx.playerpoints.storage.imports;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import lib.PatPeter.SQLibrary.SQLite;
import org.black_ixx.playerpoints.PlayerPoints;
import org.black_ixx.playerpoints.storage.IStorage;
import org.black_ixx.playerpoints.storage.StorageType;
import org.black_ixx.playerpoints.storage.imports.DatabaseImport;

public class SQLiteImport
extends DatabaseImport {
    private SQLite sqlite;

    public SQLiteImport(PlayerPoints plugin) {
        super(plugin);
        this.sqlite = new SQLite(plugin.getLogger(), " ", plugin.getDataFolder().getAbsolutePath(), "storage");
        this.sqlite.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void doImport() {
        this.plugin.getLogger().info("Importing SQLite to MySQL");
        IStorage mysql = this.generator.createStorageHandlerForType(StorageType.MYSQL);
        ResultSet query = null;
        try {
            query = this.sqlite.query("SELECT * FROM playerpoints");
            if (query.next()) {
                do {
                    mysql.setPoints(query.getString("playername"), query.getInt("points"));
                } while (query.next());
            }
            query.close();
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "SQLException on SQLite import", e);
        }
        finally {
            this.sqlite.close();
        }
    }
}

