/*
 * Decompiled with CFR 0.152.
 */
package org.black_ixx.playerpoints.storage.models;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import lib.PatPeter.SQLibrary.MySQL;
import org.black_ixx.playerpoints.PlayerPoints;
import org.black_ixx.playerpoints.config.RootConfig;
import org.black_ixx.playerpoints.storage.DatabaseStorage;

public class MySQLStorage
extends DatabaseStorage {
    private MySQL mysql;
    private int retryLimit = 10;
    private int retryCount = 0;
    private boolean skip = false;

    public MySQLStorage(PlayerPoints plugin) {
        super(plugin);
        RootConfig config = plugin.getModuleForClass(RootConfig.class);
        if (config.debugDatabase) {
            plugin.getLogger().info("Constructor");
        }
        this.retryLimit = plugin.getModuleForClass(RootConfig.class).retryLimit;
        this.connect();
        if (!this.mysql.isTable("playerpoints")) {
            this.build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPoints(String id) {
        ResultSet result;
        PreparedStatement statement;
        RootConfig config;
        int points;
        block8: {
            points = 0;
            config = this.plugin.getModuleForClass(RootConfig.class);
            if (id == null || id.equals("")) {
                if (config.debugDatabase) {
                    this.plugin.getLogger().info("getPoints() - bad ID");
                }
                return points;
            }
            if (config.debugDatabase) {
                this.plugin.getLogger().info("getPoints(" + id + ")");
            }
            statement = null;
            result = null;
            try {
                statement = this.mysql.prepare("SELECT points FROM playerpoints WHERE playername=?;");
                statement.setString(1, id);
                result = this.mysql.query(statement);
                if (result == null || !result.next()) break block8;
                points = result.getInt("points");
            }
            catch (SQLException e) {
                block9: {
                    try {
                        this.plugin.getLogger().log(Level.SEVERE, "Could not create getter statement.", e);
                        ++this.retryCount;
                        this.connect();
                        if (this.skip) break block9;
                        points = this.getPoints(id);
                    }
                    catch (Throwable throwable) {
                        this.cleanup(result, statement);
                        throw throwable;
                    }
                }
                this.cleanup(result, statement);
            }
        }
        this.cleanup(result, statement);
        this.retryCount = 0;
        if (config.debugDatabase) {
            this.plugin.getLogger().info("getPlayers() result - " + points);
        }
        return points;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setPoints(String id, int points) {
        boolean value = false;
        RootConfig config = this.plugin.getModuleForClass(RootConfig.class);
        if (id == null || id.equals("")) {
            if (config.debugDatabase) {
                this.plugin.getLogger().info("setPoints() - bad ID");
            }
            return value;
        }
        if (config.debugDatabase) {
            this.plugin.getLogger().info("setPoints(" + id + "," + points + ")");
        }
        boolean exists = this.playerEntryExists(id);
        PreparedStatement statement = null;
        ResultSet result = null;
        try {
            statement = exists ? this.mysql.prepare("UPDATE playerpoints SET points=? WHERE playername=?") : this.mysql.prepare("INSERT INTO playerpoints (points,playername) VALUES(?,?);");
            statement.setInt(1, points);
            statement.setString(2, id);
            result = this.mysql.query(statement);
            value = true;
        }
        catch (SQLException e) {
            block8: {
                try {
                    this.plugin.getLogger().log(Level.SEVERE, "Could not create setter statement.", e);
                    ++this.retryCount;
                    this.connect();
                    if (this.skip) break block8;
                    value = this.setPoints(id, points);
                }
                catch (Throwable throwable) {
                    this.cleanup(result, statement);
                    throw throwable;
                }
            }
            this.cleanup(result, statement);
        }
        this.cleanup(result, statement);
        this.retryCount = 0;
        if (config.debugDatabase) {
            this.plugin.getLogger().info("setPoints() result - " + value);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean playerEntryExists(String id) {
        ResultSet result;
        PreparedStatement statement;
        RootConfig config;
        boolean has;
        block8: {
            has = false;
            config = this.plugin.getModuleForClass(RootConfig.class);
            if (id == null || id.equals("")) {
                if (config.debugDatabase) {
                    this.plugin.getLogger().info("playerEntryExists() - bad ID");
                }
                return has;
            }
            if (config.debugDatabase) {
                this.plugin.getLogger().info("playerEntryExists(" + id + ")");
            }
            statement = null;
            result = null;
            try {
                statement = this.mysql.prepare("SELECT points FROM playerpoints WHERE playername=?;");
                statement.setString(1, id);
                result = this.mysql.query(statement);
                if (!result.next()) break block8;
                has = true;
            }
            catch (SQLException e) {
                block9: {
                    try {
                        this.plugin.getLogger().log(Level.SEVERE, "Could not create player check statement.", e);
                        ++this.retryCount;
                        this.connect();
                        if (this.skip) break block9;
                        has = this.playerEntryExists(id);
                    }
                    catch (Throwable throwable) {
                        this.cleanup(result, statement);
                        throw throwable;
                    }
                }
                this.cleanup(result, statement);
            }
        }
        this.cleanup(result, statement);
        this.retryCount = 0;
        if (config.debugDatabase) {
            this.plugin.getLogger().info("playerEntryExists() result - " + has);
        }
        return has;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removePlayer(String id) {
        boolean deleted = false;
        if (id == null || id.equals("")) {
            return deleted;
        }
        PreparedStatement statement = null;
        ResultSet result = null;
        RootConfig config = this.plugin.getModuleForClass(RootConfig.class);
        if (config.debugDatabase) {
            this.plugin.getLogger().info("removePlayers(" + id + ")");
        }
        try {
            statement = this.mysql.prepare("DELETE playerpoints WHERE playername=?");
            statement.setString(1, id);
            result = this.mysql.query(statement);
            deleted = true;
        }
        catch (SQLException e) {
            block7: {
                try {
                    this.plugin.getLogger().log(Level.SEVERE, "Could not create player remove statement.", e);
                    ++this.retryCount;
                    this.connect();
                    if (this.skip) break block7;
                    deleted = this.playerEntryExists(id);
                }
                catch (Throwable throwable) {
                    this.cleanup(result, statement);
                    throw throwable;
                }
            }
            this.cleanup(result, statement);
        }
        this.cleanup(result, statement);
        this.retryCount = 0;
        if (config.debugDatabase) {
            this.plugin.getLogger().info("renovePlayers() result - " + deleted);
        }
        return deleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getPlayers() {
        HashSet<String> players = new HashSet<String>();
        RootConfig config = this.plugin.getModuleForClass(RootConfig.class);
        if (config.debugDatabase) {
            this.plugin.getLogger().info("Attempting getPlayers()");
        }
        PreparedStatement statement = null;
        ResultSet result = null;
        try {
            statement = this.mysql.prepare("SELECT playername FROM playerpoints;");
            result = this.mysql.query(statement);
            while (result.next()) {
                String name = result.getString("playername");
                if (name == null) continue;
                players.add(name);
            }
        }
        catch (SQLException e) {
            block7: {
                try {
                    this.plugin.getLogger().log(Level.SEVERE, "Could not create get players statement.", e);
                    ++this.retryCount;
                    this.connect();
                    if (this.skip) break block7;
                    players.clear();
                    players.addAll(this.getPlayers());
                }
                catch (Throwable throwable) {
                    this.cleanup(result, statement);
                    throw throwable;
                }
            }
            this.cleanup(result, statement);
        }
        this.cleanup(result, statement);
        this.retryCount = 0;
        if (config.debugDatabase) {
            this.plugin.getLogger().info("getPlayers() result - " + players.size());
        }
        return players;
    }

    private void connect() {
        RootConfig config = this.plugin.getModuleForClass(RootConfig.class);
        if (this.mysql != null) {
            if (config.debugDatabase) {
                this.plugin.getLogger().info("Closing existing MySQL connection");
            }
            this.mysql.close();
        }
        this.mysql = new MySQL(this.plugin.getLogger(), " ", config.host, Integer.valueOf(config.port).intValue(), config.database, config.user, config.password);
        if (config.debugDatabase) {
            this.plugin.getLogger().info("Attempting MySQL connection to " + config.user + "@" + config.host + ":" + config.port + "/" + config.database);
        }
        if (this.retryCount < this.retryLimit) {
            this.mysql.open();
        } else {
            this.plugin.getLogger().severe("Tried connecting to MySQL " + this.retryLimit + " times and could not connect.");
            this.plugin.getLogger().severe("It may be in your best interest to restart the plugin / server.");
            this.retryCount = 0;
            this.skip = true;
        }
    }

    @Override
    public boolean destroy() {
        boolean success = false;
        RootConfig config = this.plugin.getModuleForClass(RootConfig.class);
        if (config.debugDatabase) {
            this.plugin.getLogger().info("Dropping playerpoints table");
        }
        try {
            this.mysql.query("DROP TABLE playerpoints;");
            success = true;
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not drop MySQL table.", e);
        }
        return success;
    }

    @Override
    public boolean build() {
        boolean success = false;
        RootConfig config = this.plugin.getModuleForClass(RootConfig.class);
        if (config.debugDatabase) {
            this.plugin.getLogger().info("Creating playerpoints table");
        }
        try {
            this.mysql.query("CREATE TABLE playerpoints (id INT UNSIGNED NOT NULL AUTO_INCREMENT, playername varchar(36) NOT NULL, points INT NOT NULL, PRIMARY KEY(id), UNIQUE(playername));");
            success = true;
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not create MySQL table.", e);
        }
        return success;
    }
}

