/*
 * Decompiled with CFR 0.152.
 */
package org.black_ixx.playerpoints.storage.models;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import lib.PatPeter.SQLibrary.SQLite;
import org.black_ixx.playerpoints.PlayerPoints;
import org.black_ixx.playerpoints.storage.DatabaseStorage;

public class SQLiteStorage
extends DatabaseStorage {
    private SQLite sqlite;

    public SQLiteStorage(PlayerPoints plugin) {
        super(plugin);
        this.sqlite = new SQLite(plugin.getLogger(), " ", plugin.getDataFolder().getAbsolutePath(), "storage");
        this.sqlite.open();
        if (!this.sqlite.isTable("playerpoints")) {
            this.build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPoints(String name) {
        ResultSet result;
        PreparedStatement statement;
        int points;
        block5: {
            points = 0;
            if (name == null || name.equals("")) {
                return points;
            }
            statement = null;
            result = null;
            try {
                statement = this.sqlite.prepare("SELECT points FROM playerpoints WHERE playername=?;");
                statement.setString(1, name);
                result = this.sqlite.query(statement);
                if (result == null || !result.next()) break block5;
                points = result.getInt("points");
            }
            catch (SQLException e) {
                try {
                    this.plugin.getLogger().log(Level.SEVERE, "Could not create getter statement.", e);
                }
                catch (Throwable throwable) {
                    this.cleanup(result, statement);
                    throw throwable;
                }
                this.cleanup(result, statement);
            }
        }
        this.cleanup(result, statement);
        return points;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setPoints(String name, int points) {
        boolean value = false;
        if (name == null || name.equals("")) {
            return value;
        }
        boolean exists = this.playerEntryExists(name);
        PreparedStatement statement = null;
        ResultSet result = null;
        try {
            statement = exists ? this.sqlite.prepare("UPDATE playerpoints SET points=? WHERE playername=?") : this.sqlite.prepare("INSERT INTO playerpoints (points,playername) VALUES(?,?);");
            statement.setInt(1, points);
            statement.setString(2, name);
            result = this.sqlite.query(statement);
            value = true;
        }
        catch (SQLException e) {
            try {
                this.plugin.getLogger().log(Level.SEVERE, "Could not create setter statement.", e);
            }
            catch (Throwable throwable) {
                this.cleanup(result, statement);
                throw throwable;
            }
            this.cleanup(result, statement);
        }
        this.cleanup(result, statement);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean playerEntryExists(String name) {
        ResultSet result;
        PreparedStatement statement;
        boolean has;
        block5: {
            has = false;
            if (name == null || name.equals("")) {
                return has;
            }
            statement = null;
            result = null;
            try {
                statement = this.sqlite.prepare("SELECT points FROM playerpoints WHERE playername=?;");
                statement.setString(1, name);
                result = this.sqlite.query(statement);
                if (!result.next()) break block5;
                has = true;
            }
            catch (SQLException e) {
                try {
                    this.plugin.getLogger().log(Level.SEVERE, "Could not create player check statement.", e);
                }
                catch (Throwable throwable) {
                    this.cleanup(result, statement);
                    throw throwable;
                }
                this.cleanup(result, statement);
            }
        }
        this.cleanup(result, statement);
        return has;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removePlayer(String id) {
        boolean deleted = false;
        if (id == null || id.equals("")) {
            return deleted;
        }
        PreparedStatement statement = null;
        ResultSet result = null;
        try {
            statement = this.sqlite.prepare("DELETE playerpoints WHERE playername=?");
            statement.setString(1, id);
            result = this.sqlite.query(statement);
            deleted = true;
        }
        catch (SQLException e) {
            try {
                this.plugin.getLogger().log(Level.SEVERE, "Could not create player remove statement.", e);
            }
            catch (Throwable throwable) {
                this.cleanup(result, statement);
                throw throwable;
            }
            this.cleanup(result, statement);
        }
        this.cleanup(result, statement);
        return deleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getPlayers() {
        HashSet<String> players = new HashSet<String>();
        PreparedStatement statement = null;
        ResultSet result = null;
        try {
            statement = this.sqlite.prepare("SELECT playername FROM playerpoints;");
            result = this.sqlite.query(statement);
            while (result.next()) {
                String name = result.getString("playername");
                if (name == null) continue;
                players.add(name);
            }
        }
        catch (SQLException e) {
            try {
                this.plugin.getLogger().log(Level.SEVERE, "Could not create get players statement.", e);
            }
            catch (Throwable throwable) {
                this.cleanup(result, statement);
                throw throwable;
            }
            this.cleanup(result, statement);
        }
        this.cleanup(result, statement);
        return players;
    }

    @Override
    public boolean destroy() {
        boolean success = false;
        this.plugin.getLogger().info("Creating playerpoints table");
        try {
            this.sqlite.query("DROP TABLE playerpoints;");
            success = true;
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not drop SQLite table.", e);
        }
        return success;
    }

    @Override
    public boolean build() {
        boolean success = false;
        this.plugin.getLogger().info("Creating playerpoints table");
        try {
            this.sqlite.query("CREATE TABLE playerpoints (id INTEGER PRIMARY KEY, playername varchar(36) NOT NULL, points INTEGER NOT NULL, UNIQUE(playername));");
            success = true;
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not create SQLite table.", e);
        }
        return success;
    }
}

