/*
 * Decompiled with CFR 0.152.
 */
package org.black_ixx.playerpoints.storage.models;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import org.black_ixx.playerpoints.PlayerPoints;
import org.black_ixx.playerpoints.storage.IStorage;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public class YAMLStorage
implements IStorage {
    private PlayerPoints plugin;
    private File file;
    private YamlConfiguration config;
    private static final String POINTS_SECTION = "Points.";

    public YAMLStorage(PlayerPoints pp) {
        this.plugin = pp;
        this.file = new File(this.plugin.getDataFolder().getAbsolutePath() + "/storage.yml");
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
        this.save();
    }

    public void save() {
        try {
            this.config.save(this.file);
        }
        catch (IOException e1) {
            this.plugin.getLogger().warning("File I/O Exception on saving storage.yml");
            e1.printStackTrace();
        }
    }

    public void reload() {
        try {
            this.config.load(this.file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InvalidConfigurationException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean setPoints(String id, int points) {
        this.config.set(POINTS_SECTION + id, (Object)points);
        this.save();
        return true;
    }

    @Override
    public int getPoints(String id) {
        int points = this.config.getInt(POINTS_SECTION + id, 0);
        return points;
    }

    @Override
    public boolean playerEntryExists(String id) {
        return this.config.contains(POINTS_SECTION + id);
    }

    @Override
    public boolean removePlayer(String id) {
        this.config.set(POINTS_SECTION + id, null);
        return true;
    }

    @Override
    public Collection<String> getPlayers() {
        Set players = Collections.emptySet();
        if (this.config.isConfigurationSection("Points")) {
            players = this.config.getConfigurationSection("Points").getKeys(false);
        }
        return players;
    }

    @Override
    public boolean destroy() {
        Set sections = this.config.getKeys(false);
        for (String section : sections) {
            this.config.set(section, null);
        }
        return true;
    }

    @Override
    public boolean build() {
        boolean success = false;
        try {
            success = this.file.createNewFile();
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to create storage file!", e);
        }
        return success;
    }
}

