/*
 * Decompiled with CFR 0.152.
 */
package org.black_ixx.playerpoints.update;

import java.util.SortedSet;
import java.util.TreeSet;
import org.black_ixx.playerpoints.PlayerPoints;
import org.black_ixx.playerpoints.services.version.Version;
import org.black_ixx.playerpoints.update.UpdateModule;
import org.black_ixx.playerpoints.update.modules.OneFiveTwoUpdate;
import org.black_ixx.playerpoints.update.modules.OneFiveUpdate;
import org.black_ixx.playerpoints.update.modules.TwoZeroZeroUpdate;
import org.bukkit.configuration.file.FileConfiguration;

public class UpdateManager {
    private PlayerPoints plugin;
    private final SortedSet<UpdateModule> modules = new TreeSet<UpdateModule>();

    public UpdateManager(PlayerPoints plugin) {
        this.plugin = plugin;
        this.modules.add(new OneFiveUpdate(plugin));
        this.modules.add(new OneFiveTwoUpdate(plugin));
        this.modules.add(new TwoZeroZeroUpdate(plugin));
    }

    public void checkUpdate() {
        Version current;
        FileConfiguration config = this.plugin.getConfig();
        Version version = new Version(this.plugin.getDescription().getVersion());
        if (!version.validate()) {
            version.setIgnorePatch(true);
        }
        if (!(current = new Version(config.getString("version"))).validate()) {
            current.setIgnorePatch(true);
        }
        if (version.compareTo(current) > 0) {
            this.plugin.getLogger().info("Updating to v" + this.plugin.getDescription().getVersion());
            this.update(current);
        }
    }

    private void update(Version current) {
        for (UpdateModule module : this.modules) {
            if (!module.shouldApplyUpdate(current)) continue;
            this.plugin.getLogger().info("Applying update for " + module.getTargetVersion());
            module.update();
        }
        this.plugin.getConfig().set("version", (Object)this.plugin.getDescription().getVersion());
        this.plugin.saveConfig();
        this.plugin.getLogger().info("Upgrade to " + this.plugin.getDescription().getVersion() + " complete");
    }
}

