/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.vanish.hooks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import org.kitteh.vanish.Debuggle;
import org.kitteh.vanish.VanishPlugin;
import org.kitteh.vanish.hooks.Hook;
import org.kitteh.vanish.hooks.plugins.BPermissionsHook;
import org.kitteh.vanish.hooks.plugins.DisguiseCraftHook;
import org.kitteh.vanish.hooks.plugins.DynmapHook;
import org.kitteh.vanish.hooks.plugins.EssentialsHook;
import org.kitteh.vanish.hooks.plugins.GeoIPToolsHook;
import org.kitteh.vanish.hooks.plugins.JSONAPIHook;
import org.kitteh.vanish.hooks.plugins.ProtocolLibHook;
import org.kitteh.vanish.hooks.plugins.SpoutCraftHook;
import org.kitteh.vanish.hooks.plugins.VaultHook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HookManager {
    private final HashMap<String, Hook> hooks = new HashMap();
    private final VanishPlugin plugin;

    public HookManager(VanishPlugin plugin) {
        this.plugin = plugin;
    }

    public List<String> deregisterHook(Hook hook) {
        ArrayList<String> ret = new ArrayList<String>();
        for (Map.Entry<String, Hook> i : this.hooks.entrySet()) {
            if (!i.getValue().equals(hook)) continue;
            this.deregisterHook(i.getKey());
            ret.add(i.getKey());
        }
        return ret;
    }

    public Hook deregisterHook(String name) {
        Hook ret = this.hooks.get(name);
        this.hooks.remove(name);
        return ret;
    }

    public Hook getHook(HookType hooktype) {
        if (!this.hooks.containsKey(hooktype.name())) {
            this.registerHook(hooktype);
        }
        return this.hooks.get(hooktype.name());
    }

    public Hook getHook(String name) {
        return this.hooks.get(name);
    }

    public void onDisable() {
        for (Hook hook : this.hooks.values()) {
            hook.onDisable();
        }
    }

    public void onJoin(Player player) {
        for (Hook hook : this.hooks.values()) {
            hook.onJoin(player);
        }
    }

    public void onQuit(Player player) {
        for (Hook hook : this.hooks.values()) {
            hook.onQuit(player);
        }
    }

    public void onUnvanish(Player player) {
        for (Hook hook : this.hooks.values()) {
            hook.onUnvanish(player);
        }
    }

    public void onVanish(Player player) {
        for (Hook hook : this.hooks.values()) {
            hook.onVanish(player);
        }
    }

    public void registerHook(String name, Class<? extends Hook> hookClazz) {
        try {
            this.registerHook(name, hookClazz.getConstructor(VanishPlugin.class).newInstance(new Object[]{this.plugin}));
        }
        catch (Exception e) {
            Debuggle.log("Failed to add hook " + name);
            e.printStackTrace();
        }
    }

    public void registerHook(String name, Hook hook) {
        this.hooks.put(name, hook);
    }

    private void registerHook(HookType hook) {
        this.registerHook(hook.name(), hook.get());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HookType {
        BPermissions(BPermissionsHook.class),
        DisguiseCraft(DisguiseCraftHook.class),
        Dynmap(DynmapHook.class),
        Essentials(EssentialsHook.class),
        GeoIPTools(GeoIPToolsHook.class),
        JSONAPI(JSONAPIHook.class),
        ProtocolLib(ProtocolLibHook.class),
        SpoutCraft(SpoutCraftHook.class),
        Vault(VaultHook.class);

        private Class<? extends Hook> clazz;

        private HookType(Class<? extends Hook> clazz) {
            this.clazz = clazz;
        }

        public Class<? extends Hook> get() {
            return this.clazz;
        }
    }
}

