/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.vanish.hooks.plugins;

import java.net.InetAddress;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.kitteh.vanish.VanishPlugin;
import org.kitteh.vanish.hooks.Hook;
import uk.org.whoami.geoip.GeoIPLookup;
import uk.org.whoami.geoip.GeoIPTools;

public final class GeoIPToolsHook
extends Hook {
    private GeoIPLookup geoip = null;

    public GeoIPToolsHook(VanishPlugin plugin) {
        super(plugin);
    }

    public String getCity(Player player) {
        String result = null;
        if (this.geoip != null) {
            try {
                result = this.geoip.getLocation((InetAddress)player.getAddress().getAddress()).city;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result != null ? result : "";
    }

    public String getCountry(Player player) {
        String result = null;
        if (this.geoip != null) {
            try {
                result = this.geoip.getCountry(player.getAddress().getAddress()).getName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result != null ? result : "";
    }

    public void onDisable() {
        this.geoip = null;
    }

    public void onEnable() {
        Plugin plugin = this.plugin.getServer().getPluginManager().getPlugin("GeoIPTools");
        if (plugin != null) {
            GeoIPTools geoip = (GeoIPTools)plugin;
            this.geoip = geoip.getGeoIPLookup();
        }
    }
}

