/*
 * Decompiled with CFR 0.152.
 */
package org.kitteh.vanish.metrics;

import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.kitteh.vanish.VanishPlugin;
import org.kitteh.vanish.metrics.Counter;
import org.kitteh.vanish.metrics.Metrics;
import org.kitteh.vanish.metrics.Tracker;

public final class MetricsOverlord {
    private static Tracker command = new Tracker("");
    private static Tracker vanish = new Tracker("");
    private static Tracker unvanish = new Tracker("");
    private static Tracker toggle = new Tracker("");
    private static Tracker startup = new Tracker("");
    private static Tracker fakejoin = new Tracker("");
    private static Tracker fakequit = new Tracker("");
    private static Tracker quitinvis = new Tracker("");
    private static Tracker joininvis = new Tracker("");
    private static Metrics metrics;
    private static final String[] PERMS_PLUGINS;

    public static Tracker getCommandTracker() {
        return command;
    }

    public static Tracker getFakejoinTracker() {
        return fakejoin;
    }

    public static Tracker getFakequitTracker() {
        return fakequit;
    }

    public static Tracker getJoinInvisTracker() {
        return joininvis;
    }

    public static Tracker getQuitInvisTracker() {
        return quitinvis;
    }

    public static Tracker getToggleTracker() {
        return toggle;
    }

    public static Tracker getUnvanishTracker() {
        return unvanish;
    }

    public static Tracker getVanishTracker() {
        return vanish;
    }

    public static void init(VanishPlugin plugin) {
        command = new Tracker("Command");
        vanish = new Tracker("Vanish");
        unvanish = new Tracker("Unvanish");
        toggle = new Tracker("Toggles");
        startup = new Tracker("Startups");
        startup.increment();
        fakejoin = new Tracker("Fake Joins");
        fakequit = new Tracker("Fake Quits");
        quitinvis = new Tracker("Silent Quit");
        joininvis = new Tracker("Silent Join");
        try {
            metrics = new Metrics((Plugin)plugin);
            metrics.addCustomData(command);
            metrics.addCustomData(vanish);
            metrics.addCustomData(unvanish);
            metrics.addCustomData(toggle);
            metrics.addCustomData(startup);
            metrics.addCustomData(fakejoin);
            metrics.addCustomData(fakequit);
            metrics.addCustomData(quitinvis);
            metrics.addCustomData(joininvis);
            metrics.createGraph("Permissions").addPlotter(new Counter(MetricsOverlord.getPermsPlugin(plugin)));
            metrics.createGraph("Online Mode").addPlotter(new Counter(plugin.getServer().getOnlineMode() ? "Online" : "Offline"));
            metrics.createGraph("TagAPI").addPlotter(new Counter(plugin.getServer().getPluginManager().isPluginEnabled("TagAPI") ? "Yup" : "Nope"));
            metrics.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String getPermsPlugin(VanishPlugin plugin) {
        PluginManager pluginManager = plugin.getServer().getPluginManager();
        for (String permsplugin : PERMS_PLUGINS) {
            if (!pluginManager.isPluginEnabled(permsplugin)) continue;
            return permsplugin;
        }
        return "Unknown or None";
    }

    static {
        PERMS_PLUGINS = new String[]{"DroxPerms", "GroupManager", "PermissionsBukkit", "PermissionsEx", "Privileges", "SimplyPerms", "Starburst", "bPermissions", "zPermissions"};
    }
}

