/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.listeners.initial;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.util.ReferenceCountUtil;
import java.nio.charset.StandardCharsets;
import java.util.EnumMap;
import java.util.concurrent.TimeUnit;
import protocolsupport.api.ProtocolVersion;
import protocolsupport.protocol.listeners.IPipeLineBuilder;
import protocolsupport.protocol.listeners.initial.Minecraft152PingResponseTask;
import protocolsupport.protocol.listeners.initial.OldPingResponseTask;
import protocolsupport.protocol.storage.ProtocolStorage;
import protocolsupport.protocol.transformer.v_1_4_1_5_1_6_core.PipeLineBuilder;

public class InitialPacketDecoder
extends ChannelInboundHandlerAdapter {
    public static final String NAME = "initial_decoder";
    private static final EnumMap<ProtocolVersion, IPipeLineBuilder> pipelineBuilders = new EnumMap(ProtocolVersion.class);
    protected ByteBuf receivedData = Unpooled.buffer();
    protected volatile boolean protocolSet = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object inputObj) throws Exception {
        try {
            ByteBuf input = (ByteBuf)inputObj;
            if (!input.isReadable()) {
                return;
            }
            Channel channel = ctx.channel();
            this.receivedData.writeBytes(input.readBytes(input.readableBytes()));
            ProtocolVersion handshakeversion = ProtocolVersion.UNKNOWN;
            this.receivedData.readerIndex(0);
            short firstbyte = this.receivedData.readUnsignedByte();
            switch (firstbyte) {
                case 254: {
                    try {
                        if (this.receivedData.readableBytes() == 0) {
                            ctx.executor().schedule((Runnable)new OldPingResponseTask(this, channel), 1000L, TimeUnit.MILLISECONDS);
                            break;
                        }
                        if (this.receivedData.readUnsignedByte() != 1) break;
                        if (this.receivedData.readableBytes() == 0) {
                            ctx.executor().schedule((Runnable)new Minecraft152PingResponseTask(this, channel), 500L, TimeUnit.MILLISECONDS);
                            break;
                        }
                        if (this.receivedData.readUnsignedByte() != 250 || !"MC|PingHost".equals(new String(this.receivedData.readBytes(this.receivedData.readUnsignedShort() * 2).array(), StandardCharsets.UTF_16BE))) break;
                        this.receivedData.readUnsignedShort();
                        handshakeversion = ProtocolVersion.fromId(this.receivedData.readUnsignedByte());
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
                    break;
                }
                case 2: {
                    try {
                        handshakeversion = ProtocolVersion.fromId(this.receivedData.readUnsignedByte());
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
                    break;
                }
                default: {
                    this.receivedData.readerIndex(0);
                    ByteBuf data = this.getVarIntPrefixedData(this.receivedData);
                    if (data == null) break;
                    handshakeversion = this.readNettyHandshake(data);
                    break;
                }
            }
            if (handshakeversion != ProtocolVersion.UNKNOWN) {
                this.setProtocol(channel, this.receivedData, handshakeversion);
            }
        }
        catch (Throwable t) {
            ctx.channel().close();
        }
        finally {
            ReferenceCountUtil.release((Object)inputObj);
        }
    }

    protected void setProtocol(Channel channel, ByteBuf input, ProtocolVersion version) throws Exception {
        if (this.protocolSet) {
            return;
        }
        this.protocolSet = true;
        ProtocolStorage.setProtocolVersion(channel.remoteAddress(), version);
        channel.pipeline().remove(NAME);
        pipelineBuilders.get((Object)version).buildPipeLine(channel, version);
        input.readerIndex(0);
        channel.pipeline().firstContext().fireChannelRead((Object)input);
    }

    private ByteBuf getVarIntPrefixedData(ByteBuf byteBuf) {
        byte[] array = new byte[3];
        for (int i = 0; i < array.length; ++i) {
            if (!byteBuf.isReadable()) {
                return null;
            }
            array[i] = byteBuf.readByte();
            if (array[i] < 0) continue;
            int length = this.readVarInt(Unpooled.wrappedBuffer((byte[])array));
            if (byteBuf.readableBytes() < length) {
                return null;
            }
            return byteBuf.readBytes(length);
        }
        throw new CorruptedFrameException("Packet length is wider than 21 bit");
    }

    private ProtocolVersion readNettyHandshake(ByteBuf data) {
        if (this.readVarInt(data) == 0) {
            return ProtocolVersion.fromId(this.readVarInt(data));
        }
        return ProtocolVersion.UNKNOWN;
    }

    private int readVarInt(ByteBuf data) {
        byte b0;
        int value = 0;
        int length = 0;
        do {
            b0 = data.readByte();
            value |= (b0 & 0x7F) << length++ * 7;
            if (length <= 5) continue;
            throw new RuntimeException("VarInt too big");
        } while ((b0 & 0x80) == 128);
        return value;
    }

    static {
        IPipeLineBuilder empty = new IPipeLineBuilder(){

            @Override
            public void buildPipeLine(Channel channel, ProtocolVersion version) {
            }
        };
        pipelineBuilders.put(ProtocolVersion.MINECRAFT_1_9, empty);
        pipelineBuilders.put(ProtocolVersion.MINECRAFT_1_8, empty);
        pipelineBuilders.put(ProtocolVersion.MINECRAFT_1_7_10, empty);
        pipelineBuilders.put(ProtocolVersion.MINECRAFT_1_7_5, empty);
        PipeLineBuilder legacyBuilder = new PipeLineBuilder();
        pipelineBuilders.put(ProtocolVersion.MINECRAFT_1_6_4, legacyBuilder);
        pipelineBuilders.put(ProtocolVersion.MINECRAFT_1_6_2, legacyBuilder);
        pipelineBuilders.put(ProtocolVersion.MINECRAFT_1_5_2, legacyBuilder);
        pipelineBuilders.put(ProtocolVersion.MINECRAFT_1_4_7, legacyBuilder);
    }
}

