/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.transformer.v_1_4_1_5_1_6_core;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;

public class PacketDataSerializer {
    public static String readString(ByteBuf buf) {
        int length = buf.readUnsignedShort();
        return new String(buf.readBytes(length * 2).array(), StandardCharsets.UTF_16BE);
    }

    public static void writeString(String string, ByteBuf buf) {
        buf.writeShort(string.length());
        buf.writeBytes(string.getBytes(StandardCharsets.UTF_16BE));
    }

    public static ByteBuf readItemStackData(ByteBuf buf) {
        ByteBuf itemdata = Unpooled.buffer();
        short itemId = buf.readShort();
        itemdata.writeShort((int)itemId);
        if (itemId != -1) {
            itemdata.writeByte((int)buf.readByte());
            itemdata.writeShort((int)buf.readShort());
            short nbtlength = buf.readShort();
            itemdata.writeShort((int)nbtlength);
            if (nbtlength != -1) {
                itemdata.writeBytes(buf.readBytes((int)nbtlength).array());
            }
        }
        return itemdata.readBytes(itemdata.readableBytes());
    }

    public static ByteBuf readDatawatcherData(ByteBuf buf) {
        ByteBuf datawatcherdata = Unpooled.buffer();
        while (true) {
            short b0 = buf.readUnsignedByte();
            datawatcherdata.writeByte((int)b0);
            if (b0 == 127) break;
            int type = (b0 & 0xE0) >> 5;
            switch (type) {
                case 0: {
                    datawatcherdata.writeByte((int)buf.readByte());
                    break;
                }
                case 1: {
                    datawatcherdata.writeShort((int)buf.readShort());
                    break;
                }
                case 2: {
                    datawatcherdata.writeInt(buf.readInt());
                    break;
                }
                case 3: {
                    datawatcherdata.writeFloat(buf.readFloat());
                    break;
                }
                case 4: {
                    PacketDataSerializer.writeString(PacketDataSerializer.readString(buf), datawatcherdata);
                    break;
                }
                case 5: {
                    datawatcherdata.writeBytes(PacketDataSerializer.readItemStackData(buf).array());
                    break;
                }
                case 6: {
                    datawatcherdata.writeInt(buf.readInt());
                    datawatcherdata.writeInt(buf.readInt());
                    datawatcherdata.writeInt(buf.readInt());
                }
            }
        }
        return datawatcherdata.readBytes(datawatcherdata.readableBytes());
    }

    public static byte[] readArray(ByteBuf buf) {
        return buf.readBytes((int)buf.readShort()).array();
    }

    public static void writeArray(byte[] array, ByteBuf buf) {
        buf.writeShort(array.length);
        buf.writeBytes(array);
    }
}

