/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.transformer.v_1_4_1_5_1_6_core;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import net.md_5.bungee.protocol.PacketWrapper;
import protocolsupport.LoggerUtil;
import protocolsupport.api.ProtocolVersion;
import protocolsupport.protocol.transformer.v_1_4_1_5_1_6_core.reader.PacketReader;
import protocolsupport.utils.ReplayingDecoderBuffer;

public class PacketDecoder
extends ByteToMessageDecoder {
    private boolean server;
    private ProtocolVersion version;
    private ReplayingDecoderBuffer replay = new ReplayingDecoderBuffer();

    public PacketDecoder(boolean server, ProtocolVersion version) {
        this.server = server;
        this.version = version;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf buf, List<Object> packets) throws Exception {
        if (!buf.isReadable()) {
            return;
        }
        this.replay.setCumulation(buf);
        this.replay.markReaderIndex();
        try {
            int packetId = this.replay.readByte() & 0xFF;
            for (PacketWrapper wrapper : PacketReader.readPacket(this.version, packetId, this.replay)) {
                if (LoggerUtil.isEnabled()) {
                    LoggerUtil.debug((this.server ? "[From Client] " : "[From Server] ") + "Received packet(id: " + packetId + ", length: " + wrapper.buf.readableBytes() + (wrapper.packet != null ? ", defined data: " + wrapper.packet.toString() : "") + ")");
                }
                packets.add(wrapper);
            }
        }
        catch (ReplayingDecoderBuffer.EOFSignal e) {
            this.replay.resetReaderIndex();
        }
    }
}

