/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.transformer.v_1_4_1_5_1_6_core.entityrewrite;

import io.netty.buffer.ByteBuf;

public class ClientboundEntityRewrite {
    private static boolean[] rewriteBasic = new boolean[256];

    public static void rewriteClientbound(ByteBuf buf, int oldId, int newId) {
        int readerIndex = buf.readerIndex();
        int packetId = buf.readByte() & 0xFF;
        if (rewriteBasic[packetId]) {
            ClientboundEntityRewrite.rewriteInt(buf, oldId, newId, 1);
        }
        switch (packetId) {
            case 22: {
                ClientboundEntityRewrite.rewriteInt(buf, oldId, newId, 5);
                break;
            }
            case 23: {
                short type = buf.readUnsignedByte();
                if (type != 60 && type != 90) break;
                buf.skipBytes(14);
                int position = buf.readerIndex();
                int readId = buf.readInt();
                int changedId = -1;
                if (readId == oldId) {
                    buf.setInt(position, newId);
                    changedId = newId;
                } else if (readId == newId) {
                    buf.setInt(position, oldId);
                    changedId = oldId;
                }
                if (changedId == -1) break;
                if (changedId == 0 && readId != 0) {
                    buf.readerIndex(readerIndex);
                    buf.writerIndex(buf.readableBytes() - 6);
                    break;
                }
                if (changedId == 0 || readId != 0) break;
                buf.readerIndex(readerIndex);
                buf.capacity(buf.readableBytes() + 6);
                buf.writerIndex(buf.readableBytes() + 6);
                break;
            }
            case 29: {
                int count = buf.readByte();
                int[] ids = new int[count];
                for (int i = 0; i < count; ++i) {
                    ids[i] = buf.readInt();
                }
                buf.readerIndex(readerIndex + 1);
                buf.writerIndex(readerIndex + 1);
                buf.writeByte(count);
                for (int id : ids) {
                    if (id == oldId) {
                        id = newId;
                    } else if (id == newId) {
                        id = oldId;
                    }
                    buf.writeInt(id);
                }
                break;
            }
            case 39: {
                ClientboundEntityRewrite.rewriteInt(buf, oldId, newId, 5);
            }
        }
        buf.readerIndex(readerIndex);
    }

    protected static void rewriteInt(ByteBuf packet, int oldId, int newId, int offset) {
        int readId = packet.getInt(offset);
        if (readId == oldId) {
            packet.setInt(offset, newId);
        } else if (readId == newId) {
            packet.setInt(offset, oldId);
        }
    }

    static {
        ClientboundEntityRewrite.rewriteBasic[5] = true;
        ClientboundEntityRewrite.rewriteBasic[17] = true;
        ClientboundEntityRewrite.rewriteBasic[18] = true;
        ClientboundEntityRewrite.rewriteBasic[20] = true;
        ClientboundEntityRewrite.rewriteBasic[22] = true;
        ClientboundEntityRewrite.rewriteBasic[23] = true;
        ClientboundEntityRewrite.rewriteBasic[24] = true;
        ClientboundEntityRewrite.rewriteBasic[25] = true;
        ClientboundEntityRewrite.rewriteBasic[26] = true;
        ClientboundEntityRewrite.rewriteBasic[28] = true;
        ClientboundEntityRewrite.rewriteBasic[30] = true;
        ClientboundEntityRewrite.rewriteBasic[31] = true;
        ClientboundEntityRewrite.rewriteBasic[32] = true;
        ClientboundEntityRewrite.rewriteBasic[33] = true;
        ClientboundEntityRewrite.rewriteBasic[34] = true;
        ClientboundEntityRewrite.rewriteBasic[35] = true;
        ClientboundEntityRewrite.rewriteBasic[38] = true;
        ClientboundEntityRewrite.rewriteBasic[39] = true;
        ClientboundEntityRewrite.rewriteBasic[40] = true;
        ClientboundEntityRewrite.rewriteBasic[41] = true;
        ClientboundEntityRewrite.rewriteBasic[42] = true;
        ClientboundEntityRewrite.rewriteBasic[55] = true;
        ClientboundEntityRewrite.rewriteBasic[71] = true;
    }
}

