/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.transformer.v_1_4_1_5_1_6_core.handlers;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.BungeeServerInfo;
import net.md_5.bungee.ServerConnection;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.Util;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.connection.Server;
import net.md_5.bungee.api.event.ServerConnectedEvent;
import net.md_5.bungee.api.event.ServerKickEvent;
import net.md_5.bungee.api.event.ServerSwitchEvent;
import net.md_5.bungee.api.plugin.Event;
import net.md_5.bungee.api.score.Objective;
import net.md_5.bungee.api.score.Scoreboard;
import net.md_5.bungee.api.score.Team;
import net.md_5.bungee.chat.ComponentSerializer;
import net.md_5.bungee.connection.CancelSendSignal;
import net.md_5.bungee.connection.LoginResult;
import net.md_5.bungee.forge.ForgeServerHandler;
import net.md_5.bungee.forge.ForgeUtils;
import net.md_5.bungee.netty.ChannelWrapper;
import net.md_5.bungee.netty.HandlerBoss;
import net.md_5.bungee.netty.PacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.Protocol;
import net.md_5.bungee.protocol.packet.EncryptionRequest;
import net.md_5.bungee.protocol.packet.Handshake;
import net.md_5.bungee.protocol.packet.Kick;
import net.md_5.bungee.protocol.packet.Login;
import net.md_5.bungee.protocol.packet.LoginSuccess;
import net.md_5.bungee.protocol.packet.PluginMessage;
import net.md_5.bungee.protocol.packet.SetCompression;
import protocolsupport.api.ProtocolSupportAPI;
import protocolsupport.protocol.CheckedChannelWrapper;
import protocolsupport.protocol.transformer.v_1_4_1_5_1_6_core.handlers.EntityRewriteDownstreamBridge;
import protocolsupport.protocol.transformer.v_1_4_1_5_1_6_core.packets.HandshakePacket;
import protocolsupport.protocol.transformer.v_1_4_1_5_1_6_core.packets.LoginPacket;
import protocolsupport.protocol.transformer.v_1_4_1_5_1_6_core.packets.PluginMessagePacket;
import protocolsupport.protocol.transformer.v_1_4_1_5_1_6_core.packets.RespawnPacket;
import protocolsupport.protocol.transformer.v_1_4_1_5_1_6_core.packets.ScoreboardObjectivePacket;
import protocolsupport.protocol.transformer.v_1_4_1_5_1_6_core.packets.TeamPacket;
import protocolsupport.utils.FakeChannelContext;
import protocolsupport.utils.ReflectionUtils;

public class ServerConnectHandler
extends PacketHandler {
    private final ProxyServer bungee;
    private ChannelWrapper ch;
    private final UserConnection user;
    private final BungeeServerInfo target;
    private State thisState = State.LOGIN;
    private ForgeServerHandler handshakeHandler;

    public ServerConnectHandler(ProxyServer bungee, UserConnection user, BungeeServerInfo target) {
        this.bungee = bungee;
        this.user = user;
        this.target = target;
    }

    public ForgeServerHandler getHandshakeHandler() {
        return this.handshakeHandler;
    }

    public void exception(Throwable t) throws Exception {
        String message = "Exception Connecting:" + Util.exception((Throwable)t);
        if (this.user.getServer() == null) {
            this.user.disconnect(message);
        } else {
            this.user.sendMessage(ChatColor.RED + message);
        }
    }

    public void connected(ChannelWrapper channel) throws Exception {
        this.ch = new CheckedChannelWrapper(new FakeChannelContext(channel.getHandle()));
        this.handshakeHandler = new ForgeServerHandler(this.user, this.ch, (ServerInfo)this.target);
        Handshake originalHandshake = this.user.getPendingConnection().getHandshake();
        HandshakePacket copiedHandshake = new HandshakePacket(ProtocolSupportAPI.getProtocolVersion(this.user.getAddress()).getId(), this.user.getPendingConnection().getLoginRequest().getData(), originalHandshake.getHost(), originalHandshake.getPort());
        if (BungeeCord.getInstance().config.isIpForward()) {
            String newHost = copiedHandshake.getHost() + "\u0000" + this.user.getAddress().getHostString() + "\u0000" + this.user.getUUID();
            LoginResult profile = this.user.getPendingConnection().getLoginProfile();
            if (profile != null && profile.getProperties() != null && profile.getProperties().length > 0) {
                newHost = newHost + "\u0000" + BungeeCord.getInstance().gson.toJson((Object)profile.getProperties());
            }
            copiedHandshake.setHost(newHost);
        } else if (!this.user.getExtraDataInHandshake().isEmpty()) {
            copiedHandshake.setHost(copiedHandshake.getHost() + this.user.getExtraDataInHandshake());
        }
        this.ch.write((Object)copiedHandshake);
        this.ch.setProtocol(Protocol.LOGIN);
    }

    public void disconnected(ChannelWrapper channel) throws Exception {
        this.user.getPendingConnects().remove(this.target);
    }

    public void handle(LoginSuccess loginSuccess) throws Exception {
        Preconditions.checkState((this.thisState == State.LOGIN_SUCCESS ? 1 : 0) != 0, (Object)"Not expecting LOGIN_SUCCESS");
        this.ch.setProtocol(Protocol.GAME);
        this.thisState = State.LOGIN;
        if (this.user.getServer() != null && this.user.getForgeClientHandler().isHandshakeComplete() && this.user.getServer().isForgeServer()) {
            this.user.getForgeClientHandler().resetHandshake();
        }
        throw CancelSendSignal.INSTANCE;
    }

    public void handle(SetCompression setCompression) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Login login) throws Exception {
        Preconditions.checkState((this.thisState == State.LOGIN ? 1 : 0) != 0, (Object)"Not expecting LOGIN");
        ServerConnection server = new ServerConnection(this.ch, this.target);
        ServerConnectedEvent event = new ServerConnectedEvent((ProxiedPlayer)this.user, (Server)server);
        this.bungee.getPluginManager().callEvent((Event)event);
        this.ch.write((Object)BungeeCord.getInstance().registerChannels());
        Queue packetQueue = this.target.getPacketQueue();
        Queue queue = packetQueue;
        synchronized (queue) {
            while (!packetQueue.isEmpty()) {
                this.ch.write(packetQueue.poll());
            }
        }
        for (PluginMessage message : this.user.getPendingConnection().getRegisterMessages()) {
            this.ch.write((Object)message);
        }
        if (this.user.getSettings() != null) {
            this.ch.write((Object)this.user.getSettings());
        }
        if (this.user.getForgeClientHandler().getClientModList() == null && !this.user.getForgeClientHandler().isHandshakeComplete()) {
            this.user.getForgeClientHandler().setHandshakeComplete();
        }
        if (this.user.getServer() == null) {
            this.user.setClientEntityId(login.getEntityId());
            this.user.setServerEntityId(login.getEntityId());
            LoginPacket modLogin = new LoginPacket(login.getEntityId(), login.getGameMode(), (byte)login.getDimension(), login.getDifficulty(), (byte)this.user.getPendingConnection().getListener().getTabListSize(), login.getLevelType());
            this.user.unsafe().sendPacket((DefinedPacket)modLogin);
            ByteBuf brand = ByteBufAllocator.DEFAULT.heapBuffer();
            DefinedPacket.writeString((String)(this.bungee.getName() + " (" + this.bungee.getVersion() + ")"), (ByteBuf)brand);
            this.user.unsafe().sendPacket((DefinedPacket)new PluginMessagePacket("MC|Brand", (byte[])brand.array().clone(), this.handshakeHandler.isServerForge()));
            brand.release();
        } else {
            this.user.getTabListHandler().onServerChange();
            Scoreboard serverScoreboard = this.user.getServerSentScoreboard();
            for (Objective objective : serverScoreboard.getObjectives()) {
                this.user.unsafe().sendPacket((DefinedPacket)new ScoreboardObjectivePacket(objective.getName(), objective.getValue(), 1));
            }
            for (Team team : serverScoreboard.getTeams()) {
                this.user.unsafe().sendPacket((DefinedPacket)new TeamPacket(team.getName()));
            }
            serverScoreboard.clear();
            try {
                ReflectionUtils.invokeMethod(this.user, "sendDimensionSwitch");
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.user.disconnect("Failed to send dimension switch");
                return;
            }
            this.user.setServerEntityId(login.getEntityId());
            this.user.unsafe().sendPacket((DefinedPacket)new RespawnPacket(login.getDimension(), login.getDifficulty(), login.getGameMode(), login.getLevelType()));
            this.user.getServer().setObsolete(true);
            this.user.getServer().disconnect("Quitting");
        }
        if (!this.user.isActive()) {
            server.disconnect("Quitting");
            this.bungee.getLogger().warning("No client connected for pending server!");
            return;
        }
        this.target.addPlayer((ProxiedPlayer)this.user);
        this.user.getPendingConnects().remove(this.target);
        this.user.setDimensionChange(false);
        this.user.setServer(server);
        ((HandlerBoss)this.ch.getHandle().pipeline().get(HandlerBoss.class)).setHandler((PacketHandler)new EntityRewriteDownstreamBridge(this.bungee, this.user, server));
        this.bungee.getPluginManager().callEvent((Event)new ServerSwitchEvent((ProxiedPlayer)this.user));
        this.thisState = State.FINISHED;
        throw CancelSendSignal.INSTANCE;
    }

    public void handle(EncryptionRequest encryptionRequest) throws Exception {
        throw new RuntimeException("Server is online mode!");
    }

    public void handle(Kick kick) throws Exception {
        ServerKickEvent event;
        ServerInfo def = this.bungee.getServerInfo(this.user.getPendingConnection().getListener().getFallbackServer());
        if (Objects.equals(this.target, def)) {
            def = null;
        }
        if ((event = (ServerKickEvent)this.bungee.getPluginManager().callEvent((Event)new ServerKickEvent((ProxiedPlayer)this.user, (ServerInfo)this.target, ComponentSerializer.parse((String)kick.getMessage()), def, ServerKickEvent.State.CONNECTING))).isCancelled() && event.getCancelServer() != null) {
            this.user.connect(event.getCancelServer());
            throw CancelSendSignal.INSTANCE;
        }
        String message = this.bungee.getTranslation("connect_kick", new Object[]{this.target.getName(), event.getKickReason()});
        if (this.user.isDimensionChange()) {
            this.user.disconnect(message);
        } else {
            this.user.sendMessage(message);
        }
        throw CancelSendSignal.INSTANCE;
    }

    public void handle(PluginMessage pluginMessage) throws Exception {
        if (pluginMessage.getTag().equals("REGISTER")) {
            Set channels = ForgeUtils.readRegisteredChannels((PluginMessage)pluginMessage);
            boolean isForgeServer = false;
            for (String channel : channels) {
                if (!channel.equals("FML|HS")) continue;
                if (this.user.getServer() != null && this.user.getForgeClientHandler().isHandshakeComplete()) {
                    this.user.getForgeClientHandler().resetHandshake();
                }
                isForgeServer = true;
                break;
            }
            if (isForgeServer && !this.handshakeHandler.isServerForge()) {
                this.handshakeHandler.setServerAsForgeServer();
                this.user.setForgeServerHandler(this.handshakeHandler);
            }
        }
        if (pluginMessage.getTag().equals("FML|HS") || pluginMessage.getTag().equals("FORGE")) {
            this.handshakeHandler.handle(pluginMessage);
            throw CancelSendSignal.INSTANCE;
        }
        this.user.unsafe().sendPacket((DefinedPacket)pluginMessage);
    }

    public String toString() {
        return "[" + this.user.getName() + "] <-> ServerConnector [" + this.target.getName() + "]";
    }

    private static enum State {
        LOGIN_SUCCESS,
        ENCRYPT_RESPONSE,
        LOGIN,
        FINISHED;

    }
}

