/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.transformer.v_1_4_1_5_1_6_core.handlers;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.PlatformDependent;
import java.net.SocketAddress;
import java.util.Objects;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.BungeeServerInfo;
import net.md_5.bungee.ServerConnection;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.netty.ChannelWrapper;
import net.md_5.bungee.netty.HandlerBoss;
import net.md_5.bungee.netty.PacketHandler;
import net.md_5.bungee.netty.PipelineUtils;
import net.md_5.bungee.protocol.Protocol;
import protocolsupport.api.ProtocolSupportAPI;
import protocolsupport.injector.ServerConnectInjector;
import protocolsupport.protocol.transformer.v_1_4_1_5_1_6_core.PacketDecoder;
import protocolsupport.protocol.transformer.v_1_4_1_5_1_6_core.PacketEncoder;
import protocolsupport.protocol.transformer.v_1_4_1_5_1_6_core.handlers.ServerConnectHandler;
import protocolsupport.utils.ReflectionUtils;

public class ServerConnector
implements ServerConnectInjector.IServerConnector {
    @Override
    public void connect(UserConnection connection, ServerInfo target) {
        ServerConnector.connect(BungeeCord.getInstance(), connection, target, false);
    }

    public static void connect(final BungeeCord bungee, final UserConnection connection, final ServerInfo info, final boolean retry) {
        final BungeeServerInfo target = (BungeeServerInfo)info;
        final ServerConnection serverconn = connection.getServer();
        if (serverconn != null && Objects.equals(serverconn.getInfo(), target)) {
            connection.sendMessage(bungee.getTranslation("already_connected", new Object[0]));
            return;
        }
        if (connection.getPendingConnects().contains(target)) {
            connection.sendMessage(bungee.getTranslation("already_connecting", new Object[0]));
            return;
        }
        connection.getPendingConnects().add(target);
        ChannelInitializer<Channel> initializer = new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                PipelineUtils.BASE.initChannel(ch);
                ch.pipeline().addAfter("frame-decoder", "packet-decoder", (ChannelHandler)new PacketDecoder(false, ProtocolSupportAPI.getProtocolVersion(connection.getAddress())));
                ch.pipeline().addAfter("frame-prepender", "packet-encoder", (ChannelHandler)new PacketEncoder(Protocol.HANDSHAKE, false, connection.getPendingConnection().getVersion()));
                ch.pipeline().remove("frame-decoder");
                ch.pipeline().remove("frame-prepender");
                ((HandlerBoss)ch.pipeline().get(HandlerBoss.class)).setHandler((PacketHandler)new ServerConnectHandler((ProxyServer)bungee, connection, target));
            }
        };
        ChannelFutureListener listener = new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    future.channel().close();
                    connection.getPendingConnects().remove(target);
                    ServerInfo def = (ServerInfo)bungee.getServers().get(connection.getPendingConnection().getListener().getFallbackServer());
                    if (retry && target != def && (serverconn == null || def != serverconn.getInfo())) {
                        connection.sendMessage(bungee.getTranslation("fallback_lobby", new Object[0]));
                        ServerConnector.connect(bungee, connection, info, false);
                    } else if (connection.isDimensionChange()) {
                        connection.disconnect(bungee.getTranslation("fallback_kick", new Object[]{future.cause().getClass().getName()}));
                    } else {
                        connection.sendMessage(bungee.getTranslation("fallback_kick", new Object[]{future.cause().getClass().getName()}));
                    }
                }
            }
        };
        ChannelWrapper ch = null;
        try {
            ch = (ChannelWrapper)ReflectionUtils.getFieldValue(connection, "ch");
        }
        catch (Throwable t) {
            t.printStackTrace();
            connection.disconnect("Failed to get ChannelWrapper from UserConnection");
            return;
        }
        Bootstrap b = ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channel(PipelineUtils.getChannel())).group((EventLoopGroup)ch.getHandle().eventLoop())).handler((ChannelHandler)initializer)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)5000)).remoteAddress((SocketAddress)target.getAddress());
        if (connection.getPendingConnection().getListener().isSetLocalAddress() && !PlatformDependent.isWindows()) {
            b.localAddress(connection.getPendingConnection().getListener().getHost().getHostString(), 0);
        }
        b.connect().addListener((GenericFutureListener)listener);
    }
}

