/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.transformer.v_1_4_1_5_1_6_core.packets;

import io.netty.buffer.ByteBuf;
import net.md_5.bungee.protocol.packet.ClientSettings;
import protocolsupport.protocol.transformer.TransformedPacket;
import protocolsupport.protocol.transformer.v_1_4_1_5_1_6_core.PacketDataSerializer;

public class ClientSettingsPacket
extends ClientSettings
implements TransformedPacket {
    private String locale;
    private byte viewDistance;
    private int chatFlags;
    private boolean chatColours;
    private byte difficulty;

    public void read(ByteBuf buf) {
        this.locale = PacketDataSerializer.readString(buf);
        this.viewDistance = buf.readByte();
        byte chatState = buf.readByte();
        this.chatFlags = (byte)(chatState & 7);
        this.chatColours = (chatState & 8) == 8;
        this.difficulty = buf.readByte();
        buf.readBoolean();
    }

    @Override
    public void write(ByteBuf buf) {
        PacketDataSerializer.writeString(this.locale, buf);
        buf.writeByte((int)this.viewDistance);
        buf.writeByte(this.chatColours ? 0x10 | this.chatFlags : this.chatFlags);
        buf.writeByte((int)this.difficulty);
        buf.writeBoolean(true);
    }

    public String getLocale() {
        return this.locale;
    }

    public byte getViewDistance() {
        return this.viewDistance;
    }

    public int getChatFlags() {
        return this.chatFlags;
    }

    public boolean isChatColours() {
        return this.chatColours;
    }

    public byte getDifficulty() {
        return this.difficulty;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public void setViewDistance(byte viewDistance) {
        this.viewDistance = viewDistance;
    }

    public void setChatFlags(int chatFlags) {
        this.chatFlags = chatFlags;
    }

    public void setChatColours(boolean chatColours) {
        this.chatColours = chatColours;
    }

    public void setDifficulty(byte difficulty) {
        this.difficulty = difficulty;
    }

    @Override
    public boolean shouldWrite() {
        return true;
    }

    @Override
    public int getId() {
        return 204;
    }
}

