/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.transformer.v_1_4_1_5_1_6_core.packets;

import io.netty.buffer.ByteBuf;
import net.md_5.bungee.EncryptionUtil;
import net.md_5.bungee.protocol.packet.EncryptionRequest;
import protocolsupport.protocol.transformer.TransformedPacket;
import protocolsupport.protocol.transformer.v_1_4_1_5_1_6_core.PacketDataSerializer;

public class EncryptionRequestPacket
extends EncryptionRequest
implements TransformedPacket {
    private String serverId;
    private byte[] publicKey = EncryptionUtil.keys.getPublic().getEncoded();
    private byte[] verifyToken;

    public EncryptionRequestPacket() {
    }

    public EncryptionRequestPacket(String serverId, byte[] verifyToken) {
        this.serverId = serverId;
        this.verifyToken = (byte[])verifyToken.clone();
    }

    public void read(ByteBuf buf) {
        this.serverId = PacketDataSerializer.readString(buf);
        this.publicKey = PacketDataSerializer.readArray(buf);
        this.verifyToken = PacketDataSerializer.readArray(buf);
    }

    @Override
    public void write(ByteBuf buf) {
        PacketDataSerializer.writeString(this.serverId, buf);
        PacketDataSerializer.writeArray(this.publicKey, buf);
        PacketDataSerializer.writeArray(this.verifyToken, buf);
    }

    public String getServerId() {
        return this.serverId;
    }

    public byte[] getPublicKey() {
        return this.publicKey;
    }

    public byte[] getVerifyToken() {
        return this.verifyToken;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public void setPublicKey(byte[] publicKey) {
        this.publicKey = publicKey;
    }

    public void setVerifyToken(byte[] verifyToken) {
        this.verifyToken = verifyToken;
    }

    @Override
    public boolean shouldWrite() {
        return true;
    }

    @Override
    public int getId() {
        return 253;
    }
}

