/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.transformer.v_1_4_1_5_1_6_core.packets;

import io.netty.buffer.ByteBuf;
import net.md_5.bungee.protocol.packet.Handshake;
import protocolsupport.api.ProtocolVersion;
import protocolsupport.protocol.transformer.TransformedPacket;
import protocolsupport.protocol.transformer.v_1_4_1_5_1_6_core.PacketDataSerializer;

public class HandshakePacket
extends Handshake
implements TransformedPacket {
    private int protocolversion;
    private String username;
    private String host = "";
    private int port;
    private int requestedstate = 2;

    public HandshakePacket() {
        this.protocolversion = ProtocolVersion.MINECRAFT_1_8.getId();
    }

    public HandshakePacket(int protocolversion, String username, String host, int port) {
        this.protocolversion = protocolversion;
        this.username = username;
        this.host = host;
        this.port = port;
    }

    public void read(ByteBuf buf) {
        buf.readByte();
        this.username = PacketDataSerializer.readString(buf);
        this.host = PacketDataSerializer.readString(buf);
        this.port = buf.readInt();
    }

    @Override
    public void write(ByteBuf buf) {
        buf.writeByte(this.protocolversion);
        PacketDataSerializer.writeString(this.username, buf);
        PacketDataSerializer.writeString(this.host, buf);
        buf.writeInt(this.port);
    }

    public String getUsername() {
        return this.username;
    }

    public int getProtocolVersion() {
        return this.protocolversion;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getRequestedProtocol() {
        return this.requestedstate;
    }

    public void setProtocolVersion(int protocolVersion) {
        this.protocolversion = protocolVersion;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setRequestedProtocol(int requestedProtocol) {
        this.requestedstate = requestedProtocol;
    }

    @Override
    public int getId() {
        return 2;
    }

    @Override
    public boolean shouldWrite() {
        return true;
    }
}

