/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.transformer.v_1_4_1_5_1_6_core.packets;

import io.netty.buffer.ByteBuf;
import net.md_5.bungee.protocol.packet.Login;
import protocolsupport.protocol.transformer.TransformedPacket;
import protocolsupport.protocol.transformer.v_1_4_1_5_1_6_core.PacketDataSerializer;

public class LoginPacket
extends Login
implements TransformedPacket {
    private int entityId;
    private short gameMode;
    private int dimension;
    private short difficulty;
    private short maxPlayers;
    private String levelType;

    public LoginPacket() {
    }

    public LoginPacket(int entityId, short gameMode, byte dimension, short difficulty, short maxPlayers, String levelType) {
        this.entityId = entityId;
        this.gameMode = gameMode;
        this.dimension = dimension;
        this.difficulty = difficulty;
        this.maxPlayers = maxPlayers;
        this.levelType = levelType;
    }

    public void read(ByteBuf buf) {
        this.entityId = buf.readInt();
        this.levelType = PacketDataSerializer.readString(buf);
        this.gameMode = buf.readByte();
        this.dimension = buf.readByte();
        this.difficulty = buf.readByte();
        buf.readByte();
        this.maxPlayers = buf.readByte();
    }

    @Override
    public void write(ByteBuf buf) {
        buf.writeInt(this.entityId);
        PacketDataSerializer.writeString(this.levelType, buf);
        buf.writeByte((int)this.gameMode);
        buf.writeByte(this.dimension);
        buf.writeByte((int)this.difficulty);
        buf.writeByte(0);
        buf.writeByte((int)this.maxPlayers);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public short getGameMode() {
        return this.gameMode;
    }

    public int getDimension() {
        return this.dimension;
    }

    public short getDifficulty() {
        return this.difficulty;
    }

    public short getMaxPlayers() {
        return this.maxPlayers;
    }

    public String getLevelType() {
        return this.levelType;
    }

    public boolean isReducedDebugInfo() {
        return true;
    }

    @Override
    public boolean shouldWrite() {
        return true;
    }

    @Override
    public int getId() {
        return 1;
    }
}

