/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.transformer.v_1_4_1_5_1_6_core.packets;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.packet.PlayerListItem;
import protocolsupport.protocol.transformer.TransformedPacket;
import protocolsupport.protocol.transformer.v_1_4_1_5_1_6_core.PacketDataSerializer;
import protocolsupport.utils.Utils;

public class PlayerListItemPacket
extends PlayerListItem
implements TransformedPacket {
    private PlayerListItem.Action action;
    private PlayerListItem.Item[] items;

    public PlayerListItemPacket() {
    }

    public PlayerListItemPacket(PlayerListItem.Action action, PlayerListItem.Item item) {
        this.action = action;
        this.items = new PlayerListItem.Item[]{item};
        if (this.items[0].getDisplayName() == null) {
            ProxiedPlayer player = ProxyServer.getInstance().getPlayer(this.items[0].getUuid());
            this.items[0].setDisplayName(player != null ? player.getDisplayName() : "Unknown");
        }
    }

    public void read(ByteBuf buf) {
        String username = PacketDataSerializer.readString(buf);
        ProxiedPlayer player = ProxyServer.getInstance().getPlayer(username);
        boolean add = buf.readBoolean();
        short ping = buf.readShort();
        this.action = add ? PlayerListItem.Action.ADD_PLAYER : PlayerListItem.Action.REMOVE_PLAYER;
        PlayerListItem.Item item = new PlayerListItem.Item();
        item.setDisplayName(username);
        item.setUuid(player != null ? player.getUniqueId() : UUID.nameUUIDFromBytes(username.getBytes(StandardCharsets.UTF_8)));
        item.setGamemode(0);
        item.setPing((int)ping);
        this.items = new PlayerListItem.Item[]{item};
    }

    @Override
    public void write(ByteBuf buf) {
        PacketDataSerializer.writeString(Utils.clampString(this.items[0].getDisplayName(), 16), buf);
        buf.writeBoolean(this.action == PlayerListItem.Action.ADD_PLAYER || this.action == PlayerListItem.Action.UPDATE_DISPLAY_NAME);
        buf.writeShort(this.items[0].getPing());
    }

    public void handle(AbstractPacketHandler handler) throws Exception {
        super.handle(handler);
    }

    public PlayerListItem.Action getAction() {
        return this.action;
    }

    public PlayerListItem.Item[] getItems() {
        return this.items;
    }

    public void setAction(PlayerListItem.Action action) {
        this.action = action;
    }

    public void setItems(PlayerListItem.Item[] items) {
        this.items = items;
    }

    @Override
    public boolean shouldWrite() {
        return true;
    }

    @Override
    public int getId() {
        return 201;
    }
}

