/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.transformer.v_1_4_1_5_1_6_core.packets;

import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import net.md_5.bungee.protocol.packet.PluginMessage;
import protocolsupport.protocol.transformer.TransformedPacket;
import protocolsupport.protocol.transformer.v_1_4_1_5_1_6_core.PacketDataSerializer;

public class PluginMessagePacket
extends PluginMessage
implements TransformedPacket {
    private String tag;
    private byte[] data;
    private boolean allowExtendedPacket;

    public PluginMessagePacket() {
    }

    public PluginMessagePacket(String string, byte[] clone, boolean serverForge) {
        this.tag = string;
        this.data = clone;
        this.allowExtendedPacket = serverForge;
    }

    public void read(ByteBuf buf) {
        this.tag = PacketDataSerializer.readString(buf);
        this.data = PacketDataSerializer.readArray(buf);
    }

    @Override
    public void write(ByteBuf buf) {
        PacketDataSerializer.writeString(this.tag, buf);
        PacketDataSerializer.writeArray(this.data, buf);
    }

    public DataInput getStream() {
        return new DataInputStream(new ByteArrayInputStream(this.data));
    }

    public String getTag() {
        return this.tag;
    }

    public byte[] getData() {
        return this.data;
    }

    public boolean isAllowExtendedPacket() {
        return this.allowExtendedPacket;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public void setAllowExtendedPacket(boolean allowExtendedPacket) {
        this.allowExtendedPacket = allowExtendedPacket;
    }

    @Override
    public boolean shouldWrite() {
        return true;
    }

    @Override
    public int getId() {
        return 250;
    }
}

