/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.transformer.v_1_4_1_5_1_6_core.packets;

import io.netty.buffer.ByteBuf;
import net.md_5.bungee.protocol.packet.Respawn;
import protocolsupport.protocol.transformer.TransformedPacket;
import protocolsupport.protocol.transformer.v_1_4_1_5_1_6_core.PacketDataSerializer;

public class RespawnPacket
extends Respawn
implements TransformedPacket {
    private int dimension;
    private short difficulty;
    private short gameMode;
    private String levelType;

    public RespawnPacket() {
    }

    public RespawnPacket(int dimension, short difficulty, short gameMode, String levelType) {
        this.dimension = dimension;
        this.difficulty = difficulty;
        this.gameMode = gameMode;
        this.levelType = levelType;
    }

    public void read(ByteBuf buf) {
        this.dimension = buf.readInt();
        this.difficulty = buf.readByte();
        this.gameMode = buf.readByte();
        buf.readShort();
        this.levelType = PacketDataSerializer.readString(buf);
    }

    @Override
    public void write(ByteBuf buf) {
        buf.writeInt(this.dimension);
        buf.writeByte((int)this.difficulty);
        buf.writeByte((int)this.gameMode);
        buf.writeShort(256);
        PacketDataSerializer.writeString(this.levelType, buf);
    }

    public int getDimension() {
        return this.dimension;
    }

    public short getDifficulty() {
        return this.difficulty;
    }

    public short getGameMode() {
        return this.gameMode;
    }

    public String getLevelType() {
        return this.levelType;
    }

    public void setDimension(int dimension) {
        this.dimension = dimension;
    }

    public void setDifficulty(short difficulty) {
        this.difficulty = difficulty;
    }

    public void setGameMode(short gameMode) {
        this.gameMode = gameMode;
    }

    public void setLevelType(String levelType) {
        this.levelType = levelType;
    }

    @Override
    public boolean shouldWrite() {
        return true;
    }

    @Override
    public int getId() {
        return 9;
    }
}

