/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.transformer.v_1_4_1_5_1_6_core.packets;

import io.netty.buffer.ByteBuf;
import net.md_5.bungee.protocol.packet.ScoreboardScore;
import protocolsupport.protocol.transformer.TransformedPacket;
import protocolsupport.protocol.transformer.v_1_4_1_5_1_6_core.PacketDataSerializer;

public class ScoreboardScorePacket
extends ScoreboardScore
implements TransformedPacket {
    private String itemName;
    private byte action;
    private String scoreName;
    private int value;

    public ScoreboardScorePacket() {
    }

    public ScoreboardScorePacket(String itemName, byte action, String scoreName, int value) {
        this.itemName = itemName;
        this.action = action;
        this.scoreName = scoreName;
        this.value = value;
    }

    public void read(ByteBuf buf) {
        this.itemName = PacketDataSerializer.readString(buf);
        this.action = buf.readByte();
        if (this.action != 1) {
            this.scoreName = PacketDataSerializer.readString(buf);
            this.value = buf.readInt();
        }
    }

    @Override
    public void write(ByteBuf buf) {
        PacketDataSerializer.writeString(this.itemName, buf);
        buf.writeByte((int)this.action);
        if (this.action != 1) {
            PacketDataSerializer.writeString(this.scoreName, buf);
            buf.writeInt(this.value);
        }
    }

    public String getItemName() {
        return this.itemName;
    }

    public byte getAction() {
        return this.action;
    }

    public String getScoreName() {
        return this.scoreName;
    }

    public int getValue() {
        return this.value;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public void setAction(byte action) {
        this.action = action;
    }

    public void setScoreName(String scoreName) {
        this.scoreName = scoreName;
    }

    public void setValue(int value) {
        this.value = value;
    }

    @Override
    public boolean shouldWrite() {
        return true;
    }

    @Override
    public int getId() {
        return 207;
    }
}

