/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.transformer.v_1_4_1_5_1_6_core.packets;

import io.netty.buffer.ByteBuf;
import net.md_5.bungee.protocol.packet.Team;
import protocolsupport.protocol.transformer.TransformedPacket;
import protocolsupport.protocol.transformer.v_1_4_1_5_1_6_core.PacketDataSerializer;

public class TeamPacket
extends Team
implements TransformedPacket {
    private String name;
    private byte mode;
    private String displayName;
    private String prefix;
    private String suffix;
    private byte friendlyFire;
    private String[] players;

    public TeamPacket() {
    }

    public TeamPacket(String name) {
        this.name = name;
        this.mode = 1;
    }

    public TeamPacket(String name, byte mode, String displayName, String prefix, String suffix, byte friendlyFire, String[] players) {
        this.name = name;
        this.mode = mode;
        this.displayName = displayName;
        this.prefix = prefix;
        this.suffix = suffix;
        this.friendlyFire = friendlyFire;
        this.players = players;
    }

    public void read(ByteBuf buf) {
        this.name = PacketDataSerializer.readString(buf);
        this.mode = buf.readByte();
        if (this.mode == 0 || this.mode == 2) {
            this.displayName = PacketDataSerializer.readString(buf);
            this.prefix = PacketDataSerializer.readString(buf);
            this.suffix = PacketDataSerializer.readString(buf);
            this.friendlyFire = buf.readByte();
        }
        if (this.mode == 0 || this.mode == 3 || this.mode == 4) {
            int len = buf.readShort();
            this.players = new String[len];
            for (int i = 0; i < len; ++i) {
                this.players[i] = PacketDataSerializer.readString(buf);
            }
        }
    }

    @Override
    public void write(ByteBuf buf) {
        PacketDataSerializer.writeString(this.name, buf);
        buf.writeByte((int)this.mode);
        if (this.mode == 0 || this.mode == 2) {
            PacketDataSerializer.writeString(this.displayName, buf);
            PacketDataSerializer.writeString(this.prefix, buf);
            PacketDataSerializer.writeString(this.suffix, buf);
            buf.writeByte((int)this.friendlyFire);
        }
        if (this.mode == 0 || this.mode == 3 || this.mode == 4) {
            buf.writeShort(this.players.length);
            for (String player : this.players) {
                PacketDataSerializer.writeString(player, buf);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public byte getMode() {
        return this.mode;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public byte getFriendlyFire() {
        return this.friendlyFire;
    }

    public String[] getPlayers() {
        return this.players;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setMode(byte mode) {
        this.mode = mode;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void setFriendlyFire(byte friendlyFire) {
        this.friendlyFire = friendlyFire;
    }

    public void setPlayers(String[] players) {
        this.players = players;
    }

    @Override
    public boolean shouldWrite() {
        return true;
    }

    @Override
    public int getId() {
        return 209;
    }
}

