/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.transformer.v_1_4_1_5_1_6_core.reader;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.PacketWrapper;
import protocolsupport.api.ProtocolVersion;
import protocolsupport.protocol.transformer.v_1_4_1_5_1_6_core.packets.ChatPacket;
import protocolsupport.protocol.transformer.v_1_4_1_5_1_6_core.packets.ClientSettingsPacket;
import protocolsupport.protocol.transformer.v_1_4_1_5_1_6_core.packets.ClientStatusPacket;
import protocolsupport.protocol.transformer.v_1_4_1_5_1_6_core.packets.EncryptionRequestPacket;
import protocolsupport.protocol.transformer.v_1_4_1_5_1_6_core.packets.EncryptionResponsePacket;
import protocolsupport.protocol.transformer.v_1_4_1_5_1_6_core.packets.HandshakePacket;
import protocolsupport.protocol.transformer.v_1_4_1_5_1_6_core.packets.KeepAlivePacket;
import protocolsupport.protocol.transformer.v_1_4_1_5_1_6_core.packets.KickPacket;
import protocolsupport.protocol.transformer.v_1_4_1_5_1_6_core.packets.LoginPacket;
import protocolsupport.protocol.transformer.v_1_4_1_5_1_6_core.packets.LoginRequestPacket;
import protocolsupport.protocol.transformer.v_1_4_1_5_1_6_core.packets.PlayerListItemPacket;
import protocolsupport.protocol.transformer.v_1_4_1_5_1_6_core.packets.PluginMessagePacket;
import protocolsupport.protocol.transformer.v_1_4_1_5_1_6_core.packets.RespawnPacket;
import protocolsupport.protocol.transformer.v_1_4_1_5_1_6_core.packets.ScoreboardDispayPacket;
import protocolsupport.protocol.transformer.v_1_4_1_5_1_6_core.packets.ScoreboardObjectivePacket;
import protocolsupport.protocol.transformer.v_1_4_1_5_1_6_core.packets.ScoreboardScorePacket;
import protocolsupport.protocol.transformer.v_1_4_1_5_1_6_core.packets.StatusRequestPacket;
import protocolsupport.protocol.transformer.v_1_4_1_5_1_6_core.packets.TeamPacket;
import protocolsupport.protocol.transformer.v_1_5.reader.NonDefinedPacketReader;

public class PacketReader {
    public static PacketWrapper[] readPacket(ProtocolVersion version, int packetId, ByteBuf buf) throws IOException {
        switch (packetId) {
            case 0: {
                return new PacketWrapper[]{PacketReader.readDefinedPacket(packetId, (DefinedPacket)new KeepAlivePacket(), buf)};
            }
            case 1: {
                return new PacketWrapper[]{PacketReader.readDefinedPacket(packetId, (DefinedPacket)new LoginPacket(), buf)};
            }
            case 2: {
                HandshakePacket packet = new HandshakePacket();
                PacketWrapper handshakepacket = PacketReader.readDefinedPacket(packetId, (DefinedPacket)packet, buf);
                return new PacketWrapper[]{handshakepacket, new PacketWrapper((DefinedPacket)new LoginRequestPacket(packet.getUsername()), Unpooled.buffer())};
            }
            case 3: {
                return new PacketWrapper[]{PacketReader.readDefinedPacket(packetId, (DefinedPacket)new ChatPacket(), buf)};
            }
            case 9: {
                return new PacketWrapper[]{PacketReader.readDefinedPacket(packetId, (DefinedPacket)new RespawnPacket(), buf)};
            }
            case 201: {
                return new PacketWrapper[]{PacketReader.readDefinedPacket(packetId, (DefinedPacket)new PlayerListItemPacket(), buf)};
            }
            case 204: {
                return new PacketWrapper[]{PacketReader.readDefinedPacket(packetId, (DefinedPacket)new ClientSettingsPacket(), buf)};
            }
            case 206: {
                return new PacketWrapper[]{PacketReader.readDefinedPacket(packetId, (DefinedPacket)new ScoreboardObjectivePacket(), buf)};
            }
            case 207: {
                return new PacketWrapper[]{PacketReader.readDefinedPacket(packetId, (DefinedPacket)new ScoreboardScorePacket(), buf)};
            }
            case 205: {
                return new PacketWrapper[]{PacketReader.readDefinedPacket(packetId, (DefinedPacket)new ClientStatusPacket(), buf)};
            }
            case 208: {
                return new PacketWrapper[]{PacketReader.readDefinedPacket(packetId, (DefinedPacket)new ScoreboardDispayPacket(), buf)};
            }
            case 209: {
                return new PacketWrapper[]{PacketReader.readDefinedPacket(packetId, (DefinedPacket)new TeamPacket(), buf)};
            }
            case 252: {
                return new PacketWrapper[]{PacketReader.readDefinedPacket(packetId, (DefinedPacket)new EncryptionResponsePacket(), buf)};
            }
            case 250: {
                return new PacketWrapper[]{PacketReader.readDefinedPacket(packetId, (DefinedPacket)new PluginMessagePacket(), buf)};
            }
            case 253: {
                return new PacketWrapper[]{PacketReader.readDefinedPacket(packetId, (DefinedPacket)new EncryptionRequestPacket(), buf)};
            }
            case 254: {
                HandshakePacket packet = new HandshakePacket();
                packet.setRequestedProtocol(1);
                return new PacketWrapper[]{new PacketWrapper((DefinedPacket)packet, Unpooled.buffer()), PacketReader.readDefinedPacket(packetId, (DefinedPacket)new StatusRequestPacket(), buf)};
            }
            case 255: {
                return new PacketWrapper[]{PacketReader.readDefinedPacket(packetId, (DefinedPacket)new KickPacket(), buf)};
            }
        }
        switch (version) {
            case MINECRAFT_1_6_4: 
            case MINECRAFT_1_6_2: {
                return new PacketWrapper[]{new PacketWrapper(null, protocolsupport.protocol.transformer.v_1_6.reader.NonDefinedPacketReader.readPacket(packetId, buf))};
            }
            case MINECRAFT_1_5_2: {
                return new PacketWrapper[]{new PacketWrapper(null, NonDefinedPacketReader.readPacket(packetId, buf))};
            }
            case MINECRAFT_1_4_7: {
                return new PacketWrapper[]{new PacketWrapper(null, protocolsupport.protocol.transformer.v_1_4.reader.NonDefinedPacketReader.readPacket(packetId, buf))};
            }
        }
        throw new IOException("Wrong protocol version");
    }

    private static PacketWrapper readDefinedPacket(int packetId, DefinedPacket packet, ByteBuf buf) {
        int readerIndex = buf.readerIndex();
        packet.read(buf);
        int length = buf.readerIndex() - readerIndex;
        buf.readerIndex(readerIndex);
        ByteBuf data = Unpooled.buffer();
        data.writeByte(packetId);
        data.writeBytes(buf.readBytes(length).array());
        return new PacketWrapper(packet, data.readBytes(data.readableBytes()));
    }
}

