/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.transformer.v_1_5.reader;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import protocolsupport.protocol.transformer.v_1_4_1_5_1_6_core.PacketDataSerializer;
import protocolsupport.utils.Utils;

public class NonDefinedPacketReader {
    private static final int NOT_SUPPORTED = -2;
    private static final int MUST_READ_ALL = -1;
    private static final int[] PACKET_LENGTH = new int[256];

    public static ByteBuf readPacket(int packetId, ByteBuf buf) {
        int length = PACKET_LENGTH[packetId];
        if (length == -2) {
            throw new IllegalArgumentException("Unknown packet id: " + packetId);
        }
        ByteBuf packetdata = Unpooled.buffer();
        packetdata.writeByte(packetId);
        if (length != -1) {
            packetdata.writeBytes(buf.readBytes(length).array());
        }
        switch (packetId) {
            case 5: {
                Utils.rewriteBytes(buf, packetdata, 6);
                packetdata.writeBytes(PacketDataSerializer.readItemStackData(buf).array());
                break;
            }
            case 15: {
                Utils.rewriteBytes(buf, packetdata, 10);
                packetdata.writeBytes(PacketDataSerializer.readItemStackData(buf).array());
                Utils.rewriteBytes(buf, packetdata, 3);
                break;
            }
            case 20: {
                Utils.rewriteBytes(buf, packetdata, 4);
                PacketDataSerializer.writeString(PacketDataSerializer.readString(buf), packetdata);
                Utils.rewriteBytes(buf, packetdata, 16);
                packetdata.writeBytes(PacketDataSerializer.readDatawatcherData(buf).array());
                break;
            }
            case 23: {
                Utils.rewriteBytes(buf, packetdata, 19);
                int objectdata = buf.readInt();
                packetdata.writeInt(objectdata);
                if (objectdata == 0) break;
                Utils.rewriteBytes(buf, packetdata, 6);
                break;
            }
            case 24: {
                Utils.rewriteBytes(buf, packetdata, 26);
                packetdata.writeBytes(PacketDataSerializer.readDatawatcherData(buf).array());
                break;
            }
            case 25: {
                Utils.rewriteBytes(buf, packetdata, 4);
                PacketDataSerializer.writeString(PacketDataSerializer.readString(buf), packetdata);
                Utils.rewriteBytes(buf, packetdata, 16);
                break;
            }
            case 29: {
                byte count = buf.readByte();
                packetdata.writeByte((int)count);
                Utils.rewriteBytes(buf, packetdata, count * 4);
                break;
            }
            case 40: {
                Utils.rewriteBytes(buf, packetdata, 4);
                packetdata.writeBytes(PacketDataSerializer.readDatawatcherData(buf));
                break;
            }
            case 51: {
                Utils.rewriteBytes(buf, packetdata, 13);
                int size = buf.readInt();
                packetdata.writeInt(size);
                Utils.rewriteBytes(buf, packetdata, size);
                break;
            }
            case 52: {
                Utils.rewriteBytes(buf, packetdata, 10);
                int size = buf.readInt();
                packetdata.writeInt(size);
                Utils.rewriteBytes(buf, packetdata, size);
                break;
            }
            case 56: {
                short chunkcount = buf.readShort();
                packetdata.writeShort((int)chunkcount);
                int size = buf.readInt();
                packetdata.writeInt(size);
                packetdata.writeBoolean(buf.readBoolean());
                Utils.rewriteBytes(buf, packetdata, size);
                Utils.rewriteBytes(buf, packetdata, 12 * chunkcount);
                break;
            }
            case 60: {
                Utils.rewriteBytes(buf, packetdata, 28);
                int count = buf.readInt();
                packetdata.writeInt(count);
                Utils.rewriteBytes(buf, packetdata, 3 * count);
                Utils.rewriteBytes(buf, packetdata, 12);
                break;
            }
            case 62: {
                PacketDataSerializer.writeString(PacketDataSerializer.readString(buf), packetdata);
                Utils.rewriteBytes(buf, packetdata, 17);
                break;
            }
            case 63: {
                PacketDataSerializer.writeString(PacketDataSerializer.readString(buf), packetdata);
                Utils.rewriteBytes(buf, packetdata, 32);
                break;
            }
            case 100: {
                Utils.rewriteBytes(buf, packetdata, 2);
                PacketDataSerializer.writeString(PacketDataSerializer.readString(buf), packetdata);
                Utils.rewriteBytes(buf, packetdata, 2);
                break;
            }
            case 102: {
                Utils.rewriteBytes(buf, packetdata, 7);
                packetdata.writeBytes(PacketDataSerializer.readItemStackData(buf).array());
                break;
            }
            case 103: {
                Utils.rewriteBytes(buf, packetdata, 3);
                packetdata.writeBytes(PacketDataSerializer.readItemStackData(buf).array());
                break;
            }
            case 104: {
                Utils.rewriteBytes(buf, packetdata, 1);
                int count = buf.readShort();
                packetdata.writeShort(count);
                for (int i = 0; i < count; ++i) {
                    packetdata.writeBytes(PacketDataSerializer.readItemStackData(buf).array());
                }
                break;
            }
            case 107: {
                Utils.rewriteBytes(buf, packetdata, 2);
                packetdata.writeBytes(PacketDataSerializer.readItemStackData(buf).array());
                break;
            }
            case 130: {
                Utils.rewriteBytes(buf, packetdata, 10);
                PacketDataSerializer.writeString(PacketDataSerializer.readString(buf), packetdata);
                PacketDataSerializer.writeString(PacketDataSerializer.readString(buf), packetdata);
                PacketDataSerializer.writeString(PacketDataSerializer.readString(buf), packetdata);
                PacketDataSerializer.writeString(PacketDataSerializer.readString(buf), packetdata);
                break;
            }
            case 131: {
                Utils.rewriteBytes(buf, packetdata, 4);
                short size = buf.readShort();
                packetdata.writeShort((int)size);
                Utils.rewriteBytes(buf, packetdata, size);
                break;
            }
            case 132: {
                Utils.rewriteBytes(buf, packetdata, 11);
                short size = buf.readShort();
                packetdata.writeShort((int)size);
                Utils.rewriteBytes(buf, packetdata, size);
                break;
            }
            case 203: {
                PacketDataSerializer.writeString(PacketDataSerializer.readString(buf), packetdata);
                break;
            }
        }
        return packetdata.readBytes(packetdata.readableBytes());
    }

    static {
        Arrays.fill(PACKET_LENGTH, -2);
        NonDefinedPacketReader.PACKET_LENGTH[4] = 16;
        NonDefinedPacketReader.PACKET_LENGTH[5] = -1;
        NonDefinedPacketReader.PACKET_LENGTH[6] = 12;
        NonDefinedPacketReader.PACKET_LENGTH[7] = 9;
        NonDefinedPacketReader.PACKET_LENGTH[8] = 8;
        NonDefinedPacketReader.PACKET_LENGTH[10] = 1;
        NonDefinedPacketReader.PACKET_LENGTH[11] = 33;
        NonDefinedPacketReader.PACKET_LENGTH[12] = 9;
        NonDefinedPacketReader.PACKET_LENGTH[13] = 41;
        NonDefinedPacketReader.PACKET_LENGTH[14] = 11;
        NonDefinedPacketReader.PACKET_LENGTH[15] = -1;
        NonDefinedPacketReader.PACKET_LENGTH[16] = 2;
        NonDefinedPacketReader.PACKET_LENGTH[17] = 14;
        NonDefinedPacketReader.PACKET_LENGTH[18] = 5;
        NonDefinedPacketReader.PACKET_LENGTH[19] = 5;
        NonDefinedPacketReader.PACKET_LENGTH[20] = -1;
        NonDefinedPacketReader.PACKET_LENGTH[22] = 8;
        NonDefinedPacketReader.PACKET_LENGTH[23] = -1;
        NonDefinedPacketReader.PACKET_LENGTH[24] = -1;
        NonDefinedPacketReader.PACKET_LENGTH[25] = -1;
        NonDefinedPacketReader.PACKET_LENGTH[26] = 18;
        NonDefinedPacketReader.PACKET_LENGTH[28] = 10;
        NonDefinedPacketReader.PACKET_LENGTH[29] = -1;
        NonDefinedPacketReader.PACKET_LENGTH[30] = 4;
        NonDefinedPacketReader.PACKET_LENGTH[31] = 7;
        NonDefinedPacketReader.PACKET_LENGTH[32] = 6;
        NonDefinedPacketReader.PACKET_LENGTH[33] = 9;
        NonDefinedPacketReader.PACKET_LENGTH[34] = 18;
        NonDefinedPacketReader.PACKET_LENGTH[35] = 5;
        NonDefinedPacketReader.PACKET_LENGTH[38] = 5;
        NonDefinedPacketReader.PACKET_LENGTH[39] = 8;
        NonDefinedPacketReader.PACKET_LENGTH[40] = -1;
        NonDefinedPacketReader.PACKET_LENGTH[41] = 8;
        NonDefinedPacketReader.PACKET_LENGTH[42] = 5;
        NonDefinedPacketReader.PACKET_LENGTH[43] = 8;
        NonDefinedPacketReader.PACKET_LENGTH[51] = -1;
        NonDefinedPacketReader.PACKET_LENGTH[52] = -1;
        NonDefinedPacketReader.PACKET_LENGTH[53] = 12;
        NonDefinedPacketReader.PACKET_LENGTH[54] = 14;
        NonDefinedPacketReader.PACKET_LENGTH[55] = 17;
        NonDefinedPacketReader.PACKET_LENGTH[56] = -1;
        NonDefinedPacketReader.PACKET_LENGTH[60] = -1;
        NonDefinedPacketReader.PACKET_LENGTH[61] = 18;
        NonDefinedPacketReader.PACKET_LENGTH[62] = -1;
        NonDefinedPacketReader.PACKET_LENGTH[63] = -1;
        NonDefinedPacketReader.PACKET_LENGTH[70] = 2;
        NonDefinedPacketReader.PACKET_LENGTH[71] = 17;
        NonDefinedPacketReader.PACKET_LENGTH[100] = -1;
        NonDefinedPacketReader.PACKET_LENGTH[101] = 1;
        NonDefinedPacketReader.PACKET_LENGTH[102] = -1;
        NonDefinedPacketReader.PACKET_LENGTH[103] = -1;
        NonDefinedPacketReader.PACKET_LENGTH[104] = -1;
        NonDefinedPacketReader.PACKET_LENGTH[105] = 5;
        NonDefinedPacketReader.PACKET_LENGTH[106] = 4;
        NonDefinedPacketReader.PACKET_LENGTH[107] = -1;
        NonDefinedPacketReader.PACKET_LENGTH[108] = 2;
        NonDefinedPacketReader.PACKET_LENGTH[130] = -1;
        NonDefinedPacketReader.PACKET_LENGTH[131] = -1;
        NonDefinedPacketReader.PACKET_LENGTH[132] = -1;
        NonDefinedPacketReader.PACKET_LENGTH[200] = 5;
        NonDefinedPacketReader.PACKET_LENGTH[202] = 3;
        NonDefinedPacketReader.PACKET_LENGTH[203] = -1;
        NonDefinedPacketReader.PACKET_LENGTH[205] = 1;
    }
}

