/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.utils;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ReflectionUtils {
    public static <T> T invokeMethod(Object target, String name) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class<?> clazz = target.getClass();
        do {
            for (Method method : clazz.getDeclaredMethods()) {
                if (!method.getName().equals(name)) continue;
                return (T)ReflectionUtils.setAccessible(method).invoke(target, new Object[0]);
            }
        } while ((clazz = clazz.getSuperclass()) != null);
        return null;
    }

    public static <T> T getFieldValue(Object target, String name) throws IllegalArgumentException, IllegalAccessException {
        Class<?> clazz = target.getClass();
        do {
            for (Field field : clazz.getDeclaredFields()) {
                if (!field.getName().equals(name)) continue;
                return (T)ReflectionUtils.setAccessible(field).get(target);
            }
        } while ((clazz = clazz.getSuperclass()) != null);
        return null;
    }

    public static void setFieldValue(Object target, String name, Object value) throws IllegalArgumentException, IllegalAccessException {
        Class<?> clazz = target.getClass();
        do {
            for (Field field : clazz.getDeclaredFields()) {
                if (!field.getName().equals(name)) continue;
                ReflectionUtils.setAccessible(field).set(target, value);
            }
        } while ((clazz = clazz.getSuperclass()) != null);
    }

    public static <T extends AccessibleObject> T setAccessible(T object) {
        object.setAccessible(true);
        return object;
    }

    public static void setStaticFinalField(Field field, Object newValue) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        ReflectionUtils.setAccessible(Field.class.getDeclaredField("modifiers")).setInt(field, field.getModifiers() & 0xFFFFFFEF);
        ReflectionUtils.setAccessible(Field.class.getDeclaredField("root")).set(field, null);
        ReflectionUtils.setAccessible(Field.class.getDeclaredField("overrideFieldAccessor")).set(field, null);
        ReflectionUtils.setAccessible(field).set(null, newValue);
    }
}

