/*
 * Decompiled with CFR 0.152.
 */
package PluginExample;

import PluginExample.MyPlugin;
import PluginReference.ChatColor;
import PluginReference.MC_Command;
import PluginReference.MC_CommandSenderInfo;
import PluginReference.MC_Player;
import PluginReference.RainbowUtils;
import java.util.List;

public abstract class CmdBase
implements MC_Command {
    private final String name;
    private final String description;

    public CmdBase(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public String getHelpLine(MC_Player plr) {
        return ChatColor.LIGHT_PURPLE + "/" + this.name + ChatColor.WHITE + " --- " + RainbowUtils.RainbowString((String)this.description);
    }

    public String getCommandName() {
        return this.name;
    }

    public List<String> getAliases() {
        return null;
    }

    public void handleCommand(MC_Player plr, String[] args) {
        MC_CommandSenderInfo info = MyPlugin.server.getExecutingCommandInfo();
        if (info != null) {
            System.out.println("-----------------------------------");
            System.out.println("Command Line: " + info.lastCommand);
            System.out.println("Sender Type: " + info.senderType);
            System.out.println("-----------------------------------");
        }
        if (plr == null) {
            System.out.println("--- Only for players!");
            return;
        }
        this.execute(plr, args);
    }

    protected abstract void execute(MC_Player var1, String[] var2);

    public boolean hasPermissionToUse(MC_Player plr) {
        return plr == null || plr.hasPermission("pluginexample." + this.name);
    }

    public List<String> getTabCompletionList(MC_Player plr, String[] args) {
        return null;
    }
}

