/*
 * Decompiled with CFR 0.152.
 */
package PluginExample;

import PluginExample.commands.CmdASAllArms;
import PluginExample.commands.CmdASAllBase;
import PluginExample.commands.CmdASNoArms;
import PluginExample.commands.CmdASNoBase;
import PluginExample.commands.CmdASPose;
import PluginExample.commands.CmdArrows;
import PluginExample.commands.CmdAsArmsOnly;
import PluginExample.commands.CmdAsBaseOnly;
import PluginExample.commands.CmdAttributeTest;
import PluginExample.commands.CmdBiome;
import PluginExample.commands.CmdBurn;
import PluginExample.commands.CmdCarry;
import PluginExample.commands.CmdCat;
import PluginExample.commands.CmdChunkTest1;
import PluginExample.commands.CmdChunkTest2;
import PluginExample.commands.CmdChunkTest3;
import PluginExample.commands.CmdClearItemName;
import PluginExample.commands.CmdClearLore;
import PluginExample.commands.CmdDrop1;
import PluginExample.commands.CmdDrop2;
import PluginExample.commands.CmdECarry;
import PluginExample.commands.CmdEHead;
import PluginExample.commands.CmdEnchants;
import PluginExample.commands.CmdFly;
import PluginExample.commands.CmdFlySpeed;
import PluginExample.commands.CmdGetBurn;
import PluginExample.commands.CmdGetLore;
import PluginExample.commands.CmdGui;
import PluginExample.commands.CmdHat;
import PluginExample.commands.CmdHead;
import PluginExample.commands.CmdHeal;
import PluginExample.commands.CmdHero;
import PluginExample.commands.CmdInfo;
import PluginExample.commands.CmdItemInfo;
import PluginExample.commands.CmdItemsGold;
import PluginExample.commands.CmdNameItem;
import PluginExample.commands.CmdNearinvis;
import PluginExample.commands.CmdNearvis;
import PluginExample.commands.CmdNether;
import PluginExample.commands.CmdNickClear;
import PluginExample.commands.CmdNickTest;
import PluginExample.commands.CmdRemEffects;
import PluginExample.commands.CmdSetAbsorb;
import PluginExample.commands.CmdSetBiome;
import PluginExample.commands.CmdSetFly;
import PluginExample.commands.CmdSetHead;
import PluginExample.commands.CmdSetLore;
import PluginExample.commands.CmdShake;
import PluginExample.commands.CmdStalkMe;
import PluginExample.commands.CmdTest1;
import PluginExample.commands.CmdTestEffects;
import PluginExample.commands.CmdTestSpawn;
import PluginExample.commands.CmdWalkSpeed;
import PluginExample.commands.CmdWorlds;
import PluginReference.ChatColor;
import PluginReference.MC_Command;
import PluginReference.MC_Entity;
import PluginReference.MC_ItemStack;
import PluginReference.MC_Location;
import PluginReference.MC_Player;
import PluginReference.MC_Server;
import PluginReference.MC_World;
import PluginReference.PluginBase;
import PluginReference.PluginInfo;
import PluginReference.RainbowUtils;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import net.md_5.bungee.config.Configuration;

public class MyPlugin
extends PluginBase {
    public static MC_Server server = null;
    public static ConcurrentHashMap<String, MC_Location> hashCompassTarget = new ConcurrentHashMap();
    static long lastProcessedMS = 0L;
    public ConcurrentHashMap<String, String> lastInfoMap = new ConcurrentHashMap();

    public void onStartup(MC_Server argServer) {
        System.out.println("======= ExamplePlugin --- Startup! =======");
        server = argServer;
        Configuration config = this.getConfig(true);
        server.setCustomShutdownMessage(config.getString("customShutdownMessage"));
        server.registerCommand((MC_Command)new CmdArrows());
        server.registerCommand((MC_Command)new CmdASAllArms());
        server.registerCommand((MC_Command)new CmdASAllBase());
        server.registerCommand((MC_Command)new CmdAsArmsOnly());
        server.registerCommand((MC_Command)new CmdAsBaseOnly());
        server.registerCommand((MC_Command)new CmdASNoArms());
        server.registerCommand((MC_Command)new CmdASNoBase());
        server.registerCommand((MC_Command)new CmdASPose());
        server.registerCommand((MC_Command)new CmdBiome());
        server.registerCommand((MC_Command)new CmdBurn());
        server.registerCommand((MC_Command)new CmdCarry());
        server.registerCommand((MC_Command)new CmdCat());
        server.registerCommand((MC_Command)new CmdChunkTest1());
        server.registerCommand((MC_Command)new CmdChunkTest2());
        server.registerCommand((MC_Command)new CmdChunkTest3());
        server.registerCommand((MC_Command)new CmdClearItemName());
        server.registerCommand((MC_Command)new CmdClearLore());
        server.registerCommand((MC_Command)new CmdDrop1());
        server.registerCommand((MC_Command)new CmdDrop2());
        server.registerCommand((MC_Command)new CmdECarry());
        server.registerCommand((MC_Command)new CmdEHead());
        server.registerCommand((MC_Command)new CmdEnchants());
        server.registerCommand((MC_Command)new CmdFly());
        server.registerCommand((MC_Command)new CmdFlySpeed());
        server.registerCommand((MC_Command)new CmdGetBurn());
        server.registerCommand((MC_Command)new CmdGetLore());
        server.registerCommand((MC_Command)new CmdHat());
        server.registerCommand((MC_Command)new CmdHead());
        server.registerCommand((MC_Command)new CmdHeal());
        server.registerCommand((MC_Command)new CmdHero());
        server.registerCommand((MC_Command)new CmdInfo());
        server.registerCommand((MC_Command)new CmdItemInfo());
        server.registerCommand((MC_Command)new CmdItemsGold());
        server.registerCommand((MC_Command)new CmdNameItem());
        server.registerCommand((MC_Command)new CmdNearinvis());
        server.registerCommand((MC_Command)new CmdNearvis());
        server.registerCommand((MC_Command)new CmdNether());
        server.registerCommand((MC_Command)new CmdNickClear());
        server.registerCommand((MC_Command)new CmdNickTest());
        server.registerCommand((MC_Command)new CmdRemEffects());
        server.registerCommand((MC_Command)new CmdSetAbsorb());
        server.registerCommand((MC_Command)new CmdSetBiome());
        server.registerCommand((MC_Command)new CmdSetFly());
        server.registerCommand((MC_Command)new CmdSetHead());
        server.registerCommand((MC_Command)new CmdSetLore());
        server.registerCommand((MC_Command)new CmdShake());
        server.registerCommand((MC_Command)new CmdStalkMe());
        server.registerCommand((MC_Command)new CmdTest1());
        server.registerCommand((MC_Command)new CmdTestEffects());
        server.registerCommand((MC_Command)new CmdTestSpawn());
        server.registerCommand((MC_Command)new CmdWalkSpeed());
        server.registerCommand((MC_Command)new CmdWorlds());
        server.registerCommand((MC_Command)new CmdAttributeTest());
        server.registerCommand((MC_Command)new CmdGui());
        server.addRecipe(server.createItemStack("stone_pickaxe", 1), new Object[]{"XXX", " I ", " I ", Character.valueOf('X'), server.createItemStack("stone", 1), Character.valueOf('I'), server.createItemStack("stick", 1)});
        server.addShapelessRecipe(server.createItemStack("leather", 1), new MC_ItemStack[]{server.createItemStack("rotten_flesh", 1)});
    }

    public void onShutdown() {
        System.out.println("======= ExamplePlugin --- Shutdown! =======");
    }

    public void onServerFullyLoaded() {
        server.setServerMOTD("Hello from PluginExample");
        server.setServerIconFilename("icon2.png");
    }

    public PluginInfo getPluginInfo() {
        PluginInfo info = new PluginInfo();
        info.description = "Rainbow Plugin Sample";
        info.eventSortOrder = 1000.0;
        info.pluginNamesINeedToGetEventsBefore = new ArrayList();
        info.pluginNamesINeedToGetEventsBefore.add("RainbowZones");
        return info;
    }

    public void onInteracted(MC_Player plr, MC_Location loc, MC_ItemStack isHandItem) {
        if (isHandItem.getOfficialName().equals("compass")) {
            plr.setCompassTarget(loc);
        }
    }

    public void onPlayerJoin(MC_Player plr) {
        plr.setPlayerListHeaderFooter(ChatColor.GOLD + "Welcome " + RainbowUtils.RainbowString((String)plr.getName()), ChatColor.AQUA + "This server is running\nRainbow v" + ChatColor.YELLOW + server.getRainbowVersion());
    }

    public void onTick(int tickNumber) {
        long ms = System.currentTimeMillis();
        if (ms - lastProcessedMS < 500L) {
            return;
        }
        lastProcessedMS = ms;
        for (MC_Player plr : server.getPlayers()) {
            MC_Entity vehicle;
            MC_Entity rider;
            MC_World world = plr.getWorld();
            MC_Location loc = plr.getLocation();
            int x = (int)Math.floor(loc.x);
            int y = loc.getBlockY() - 1;
            int z = (int)Math.floor(loc.z);
            ArrayList<String> info = new ArrayList<String>();
            if (plr.isDead()) {
                info.add("Dead");
            }
            if (plr.isSleeping()) {
                info.add("Sleeping");
            }
            if (plr.isSneaking()) {
                info.add("Sneaking");
            }
            if (plr.isSprinting()) {
                info.add("Sprinting");
            }
            if (plr.isInvisible()) {
                info.add("Invisible");
            }
            if (plr.isInvulnerable()) {
                info.add("Invulnerable");
            }
            if ((rider = plr.getRider()) != null) {
                info.add("Carrying " + rider.getType() + ": " + rider.getName());
            }
            if ((vehicle = plr.getVehicle()) != null) {
                info.add("Vehicle " + vehicle.getType() + ": " + vehicle.getName());
            }
            info.add("Gamemode: " + plr.getGameMode());
            if (info.size() > 0) {
                String infoMsg = RainbowUtils.GetCommaList(info);
                String lastMsg = this.lastInfoMap.get(plr.getName());
                if (lastMsg == null || !lastMsg.equalsIgnoreCase(infoMsg)) {
                    plr.sendMessage(ChatColor.DARK_AQUA + "You are: " + ChatColor.WHITE + infoMsg);
                    this.lastInfoMap.put(plr.getName(), infoMsg);
                }
            }
            MC_Location lastTarget = hashCompassTarget.get(plr.getName());
            MC_Location curTarget = plr.getCompassTarget();
            if (curTarget == null || lastTarget != null && lastTarget.equals(curTarget)) continue;
            hashCompassTarget.put(plr.getName(), curTarget);
            plr.sendMessage(ChatColor.LIGHT_PURPLE + "Compass Target Changed: " + ChatColor.WHITE + curTarget.toString());
        }
    }
}

