/*
 * Decompiled with CFR 0.152.
 */
package PluginExample.commands;

import PluginExample.CmdBase;
import PluginExample.MyPlugin;
import PluginReference.ChatColor;
import PluginReference.MC_ItemStack;
import PluginReference.MC_Player;
import PluginReference.RainbowUtils;
import java.util.Arrays;
import java.util.List;

public class CmdHead
extends CmdBase {
    public CmdHead() {
        super("head", "Get a player head!");
    }

    @Override
    public String getCommandName() {
        return "head";
    }

    @Override
    public List<String> getAliases() {
        return Arrays.asList("skull");
    }

    @Override
    public List<String> getTabCompletionList(MC_Player plr, String[] args) {
        String plrName = "?";
        if (plr != null) {
            plrName = plr.getName();
        }
        System.out.println(String.format("Tab: plr=%s.  args=%s", plrName, RainbowUtils.GetCommaList((String[])args)));
        if (args.length >= 0) {
            return MyPlugin.server.getMatchingOnlinePlayerNames(args[0]);
        }
        return null;
    }

    @Override
    protected void execute(MC_Player plr, String[] args) {
        if (args.length <= 0) {
            plr.sendMessage(this.getHelpLine(plr));
            return;
        }
        String tgtName = args[0];
        String exactName = MyPlugin.server.getPlayerExactName(tgtName);
        if (exactName != null) {
            tgtName = exactName;
        } else {
            plr.sendMessage(ChatColor.LIGHT_PURPLE + "Warning: " + ChatColor.YELLOW + tgtName + ChatColor.LIGHT_PURPLE + " not known, will assume correct spelling...");
        }
        plr.sendMessage(ChatColor.GREEN + "Receiving player head: " + ChatColor.YELLOW + tgtName);
        MC_ItemStack is = MyPlugin.server.createItemStack("player_head", 1);
        is.setSkullOwner(tgtName);
        plr.getWorld().dropItem(is, plr.getLocation(), plr.getName());
        MC_Player pTgt = MyPlugin.server.getOnlinePlayerByName(tgtName);
        if (pTgt != null && !tgtName.equalsIgnoreCase(plr.getName())) {
            pTgt.sendMessage(ChatColor.LIGHT_PURPLE + "" + ChatColor.ITALIC + "Your head was stolen by " + ChatColor.RED + plr.getName());
        }
    }
}

