/*
 * Decompiled with CFR 0.152.
 */
package PluginExample.commands;

import PluginExample.CmdBase;
import PluginReference.ChatColor;
import PluginReference.MC_ItemStack;
import PluginReference.MC_Player;
import PluginReference.RainbowUtils;
import java.util.Collection;

public class CmdItemInfo
extends CmdBase {
    public CmdItemInfo() {
        super("iteminfo", "Info about current item.");
    }

    @Override
    protected void execute(MC_Player plr, String[] args) {
        MC_ItemStack is = plr.getItemInHand();
        if (is == null || is.getCount() == 0) {
            plr.sendMessage(ChatColor.RED + "Nothing in your hand");
            return;
        }
        int len = 16;
        plr.sendMessage(ChatColor.DARK_GRAY + "--------------------------");
        plr.sendMessage(ChatColor.AQUA + RainbowUtils.TextLabel((String)"ID", (int)len) + ChatColor.WHITE + String.format("%s", is.getOfficialName()));
        plr.sendMessage(ChatColor.AQUA + RainbowUtils.TextLabel((String)"Dmg/Subtype", (int)len) + ChatColor.WHITE + String.format("%d", is.getDamage()));
        plr.sendMessage(ChatColor.AQUA + RainbowUtils.TextLabel((String)"Lore", (int)len) + ChatColor.WHITE + RainbowUtils.GetCommaList((Collection)is.getLore()));
        plr.sendMessage(ChatColor.AQUA + RainbowUtils.TextLabel((String)"Max Stack", (int)len) + ChatColor.WHITE + is.getMaxStackSize());
        plr.sendMessage(ChatColor.AQUA + RainbowUtils.TextLabel((String)"Friendly Name", (int)len) + ChatColor.WHITE + is.getFriendlyName());
        plr.sendMessage(ChatColor.AQUA + RainbowUtils.TextLabel((String)"Official Name", (int)len) + ChatColor.WHITE + is.getOfficialName());
        String customName = is.getCustomizedName();
        if (customName == null) {
            customName = ChatColor.RED + "Not Customized";
        }
        plr.sendMessage(ChatColor.AQUA + RainbowUtils.TextLabel((String)"Custom Name", (int)len) + ChatColor.WHITE + customName);
    }
}

