/*
 * Decompiled with CFR 0.152.
 */
package PluginReference;

import PluginReference.ChatColor;
import PluginReference.MC_Location;
import PluginReference.MC_Server;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class RainbowUtils {
    private static MC_Server server;

    public static void setServer(MC_Server server) {
        RainbowUtils.server = server;
    }

    public static MC_Server getServer() {
        return server;
    }

    public static String TimeDeltaString_JustMinutesSecs(long ms) {
        long totalSecs = ms / 1000L;
        long totalMins = ms / 1000L / 60L;
        if (totalMins >= 60L) {
            long totalHours = totalMins / 60L;
            return String.format("%02dh %02dm", totalHours, totalMins % 60L);
        }
        return String.format("%02dm %02ds", totalMins, totalSecs % 60L);
    }

    public static String GetCommaList(Collection<String> arr) {
        if (arr == null || arr.size() <= 0) {
            return "";
        }
        return RainbowUtils.GetCommaList(arr, true);
    }

    public static String GetCommaList(Collection<String> arr, boolean doSort) {
        ArrayList<String> list = new ArrayList<String>(arr);
        StringBuffer buf = new StringBuffer();
        Collections.sort(list);
        for (String str : list) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(str);
        }
        return buf.toString();
    }

    public static String GetCommaList(String[] args) {
        if (args == null) {
            return "";
        }
        return RainbowUtils.GetCommaList(Arrays.asList(args));
    }

    public static String ConcatArgs(String[] args, int startIdx) {
        StringBuilder sb = new StringBuilder();
        for (int i = startIdx; i < args.length; ++i) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(args[i]);
        }
        return sb.toString();
    }

    public static Integer GetIntegerArgument(String msg, Integer defaultValue) {
        int idxSpace = msg.indexOf(" ");
        if (idxSpace >= 0) {
            try {
                return Integer.parseInt(msg.substring(idxSpace + 1));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static String RainbowString(String str) {
        return RainbowUtils.RainbowString(str, "");
    }

    public static String RainbowString(String str, String ctl) {
        if (ctl.equalsIgnoreCase("x")) {
            return str;
        }
        StringBuilder sb = new StringBuilder();
        int idx = 0;
        boolean useBold = ctl.indexOf(98) >= 0;
        boolean useItalics = ctl.indexOf(105) >= 0;
        boolean useUnderline = ctl.indexOf(117) >= 0;
        for (int i = 0; i < str.length(); ++i) {
            if (idx % 6 == 0) {
                sb.append(ChatColor.RED);
            } else if (idx % 6 == 1) {
                sb.append(ChatColor.GOLD);
            } else if (idx % 6 == 2) {
                sb.append(ChatColor.YELLOW);
            } else if (idx % 6 == 3) {
                sb.append(ChatColor.GREEN);
            } else if (idx % 6 == 4) {
                sb.append(ChatColor.AQUA);
            } else if (idx % 6 == 5) {
                sb.append(ChatColor.LIGHT_PURPLE);
            }
            if (useBold) {
                sb.append(ChatColor.BOLD);
            }
            if (useItalics) {
                sb.append(ChatColor.ITALIC);
            }
            if (useUnderline) {
                sb.append(ChatColor.UNDERLINE);
            }
            sb.append(str.charAt(i));
            if (str.charAt(i) == ' ') continue;
            ++idx;
        }
        return sb.toString();
    }

    public static String[] GetTokens(String msg) {
        return msg.split("\\s+");
    }

    public static String TextLabel(String str, int padLen) {
        return str + ChatColor.DARK_GRAY + RainbowUtils.TextAlignTrailerPerfect(str, padLen);
    }

    public static String TextAlignTrailerPerfect(String str, int padLen) {
        int i;
        StringBuffer tgt = new StringBuffer();
        int pixelsTaken = 0;
        for (int i2 = 0; i2 < str.length(); ++i2) {
            char ch = str.charAt(i2);
            if (ch == 'f') {
                pixelsTaken += 5;
                continue;
            }
            if (ch == 'i') {
                pixelsTaken += 2;
                continue;
            }
            if (ch == ',') {
                pixelsTaken += 2;
                continue;
            }
            if (ch == 'k') {
                pixelsTaken += 5;
                continue;
            }
            if (ch == 'l') {
                pixelsTaken += 3;
                continue;
            }
            if (ch == '\'') {
                pixelsTaken += 3;
                continue;
            }
            if (ch == 't') {
                pixelsTaken += 4;
                continue;
            }
            if (ch == 'I') {
                pixelsTaken += 4;
                continue;
            }
            if (ch == '[') {
                pixelsTaken += 4;
                continue;
            }
            if (ch == ']') {
                pixelsTaken += 4;
                continue;
            }
            if (ch == ' ') {
                pixelsTaken += 4;
                continue;
            }
            if (ch == '\u262e') {
                pixelsTaken += 4;
                continue;
            }
            if (ch == '\u2694') {
                pixelsTaken += 7;
                continue;
            }
            pixelsTaken += 6;
        }
        int spacesPixels = padLen * 6 - pixelsTaken;
        int left = spacesPixels % 4;
        for (i = 0; i < left; ++i) {
            tgt.append("\u205a");
        }
        for (i = 0; i < spacesPixels / 4; ++i) {
            tgt.append(" ");
        }
        return tgt.toString();
    }

    public static float YawToFaceLocation(MC_Location src, MC_Location dest) {
        double dz = -(dest.x - src.x);
        double dx = dest.z - src.z;
        if (Math.abs(dx) < 1.0E-4) {
            dx = 1.0E-4;
        }
        double yawSrcToTarget = 360.0 * Math.atan(dz / dx) / 6.283185307;
        if (dx < 0.0) {
            yawSrcToTarget += 180.0;
        }
        if (yawSrcToTarget < 0.0) {
            yawSrcToTarget += 360.0;
        }
        return (float)yawSrcToTarget;
    }

    public static float PitchToFaceLocation(MC_Location src, MC_Location dest) {
        double dz = -(dest.x - src.x);
        double dx = dest.z - src.z;
        double dy = -(dest.y - src.y);
        double d = Math.sqrt(dz * dz + dx * dx);
        if (Math.abs(d) < 1.0E-4) {
            d = 1.0E-4;
        }
        double pitchToTarget = 360.0 * Math.atan(dy / d) / 6.283185307;
        return (float)pitchToTarget;
    }

    public static String RainbowStringList(String[] strings) {
        return RainbowUtils.RainbowStringList(new ArrayList<String>(Arrays.asList(strings)));
    }

    public static String RainbowStringList(List<String> strings) {
        String res = ChatColor.RED + "None";
        if (strings.size() > 0) {
            String nextColor = ChatColor.YELLOW;
            StringBuilder sb = new StringBuilder();
            for (String iterator : strings) {
                if (sb.length() > 0) {
                    sb.append(ChatColor.WHITE + ", ");
                }
                sb.append(nextColor + iterator);
                if (nextColor == ChatColor.GOLD) {
                    nextColor = ChatColor.YELLOW;
                    continue;
                }
                if (nextColor == ChatColor.YELLOW) {
                    nextColor = ChatColor.GREEN;
                    continue;
                }
                if (nextColor == ChatColor.GREEN) {
                    nextColor = ChatColor.AQUA;
                    continue;
                }
                if (nextColor == ChatColor.AQUA) {
                    nextColor = ChatColor.LIGHT_PURPLE;
                    continue;
                }
                if (nextColor == ChatColor.LIGHT_PURPLE) {
                    nextColor = ChatColor.RED;
                    continue;
                }
                if (nextColor != ChatColor.RED) continue;
                nextColor = ChatColor.GOLD;
            }
            res = sb.toString();
        }
        return res;
    }
}

