/*
 * Decompiled with CFR 0.152.
 */
package PluginReference;

import PluginReference.MC_DirectionNESWUD;
import java.io.Serializable;

public class MC_Location
implements Serializable {
    public int dimension;
    public double x;
    public double y;
    public double z;
    public float yaw;
    public float pitch;

    public MC_Location(double x, double y, double z, int dimension, float yaw, float pitch) {
        this.dimension = dimension;
        this.x = x;
        this.y = y;
        this.z = z;
        this.pitch = pitch;
        this.yaw = yaw;
    }

    public MC_Location(double x, double y, double z, int dimension) {
        this.dimension = dimension;
        this.x = x;
        this.y = y;
        this.z = z;
        this.pitch = 0.0f;
        this.yaw = 0.0f;
    }

    public MC_Location(MC_Location locToCopy) {
        this.dimension = locToCopy.dimension;
        this.x = locToCopy.x;
        this.y = locToCopy.y;
        this.z = locToCopy.z;
        this.pitch = locToCopy.pitch;
        this.yaw = locToCopy.yaw;
    }

    public String toString() {
        String strBase = String.format("(%.1f, %.1f, %.1f)", this.x, this.y, this.z);
        if (this.dimension == 0) {
            return strBase;
        }
        String worldName = "Dimension_" + this.dimension;
        if (this.dimension == -1) {
            worldName = "Nether";
        }
        if (this.dimension == 1) {
            worldName = "TheEnd";
        }
        return worldName + strBase;
    }

    public MC_Location toBlockLocation() {
        return new MC_Location(this.getBlockX(), this.getBlockY(), this.getBlockZ(), this.dimension);
    }

    public int getBlockX() {
        return (int)Math.floor(this.x);
    }

    public int getBlockY() {
        return (int)Math.floor(this.y);
    }

    public int getBlockZ() {
        return (int)Math.floor(this.z);
    }

    public boolean equals(MC_Location loc) {
        if (loc == null) {
            return false;
        }
        if (this.x != loc.x) {
            return false;
        }
        if (this.z != loc.z) {
            return false;
        }
        if (this.y != loc.y) {
            return false;
        }
        if (this.dimension != loc.dimension) {
            return false;
        }
        if ((double)Math.abs(this.yaw - loc.yaw) > 1.0E-4) {
            return false;
        }
        return !((double)Math.abs(this.pitch - loc.pitch) > 1.0E-4);
    }

    public boolean isSameBlockLocationAs(MC_Location loc) {
        if (loc == null) {
            return false;
        }
        if (this.dimension != loc.dimension) {
            return false;
        }
        if (this.getBlockX() != loc.getBlockX()) {
            return false;
        }
        if (this.getBlockZ() != loc.getBlockZ()) {
            return false;
        }
        return this.getBlockY() == loc.getBlockY();
    }

    public double distanceTo(MC_Location loc) {
        if (loc.dimension != this.dimension) {
            return 8.988465674311579E307;
        }
        double dx = this.x - loc.x;
        double dy = this.y - loc.y;
        double dz = this.z - loc.z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public MC_Location getLocationAtDirection(MC_DirectionNESWUD dir) {
        MC_Location loc = new MC_Location(this);
        if (dir == MC_DirectionNESWUD.NORTH) {
            loc.z -= 1.0;
        }
        if (dir == MC_DirectionNESWUD.SOUTH) {
            loc.z += 1.0;
        }
        if (dir == MC_DirectionNESWUD.WEST) {
            loc.x -= 1.0;
        }
        if (dir == MC_DirectionNESWUD.EAST) {
            loc.x += 1.0;
        }
        if (dir == MC_DirectionNESWUD.UP) {
            loc.y += 1.0;
        }
        if (dir == MC_DirectionNESWUD.DOWN) {
            loc.y -= 1.0;
        }
        return loc;
    }
}

