/*
 * Decompiled with CFR 0.152.
 */
package PluginReference;

import PluginReference.MC_ArmorStandActionType;
import PluginReference.MC_Block;
import PluginReference.MC_Container;
import PluginReference.MC_ContainerType;
import PluginReference.MC_DamageType;
import PluginReference.MC_DirectionNESWUD;
import PluginReference.MC_Entity;
import PluginReference.MC_EventInfo;
import PluginReference.MC_FloatTriplet;
import PluginReference.MC_GeneratedColumn;
import PluginReference.MC_Hand;
import PluginReference.MC_HangingEntityType;
import PluginReference.MC_ItemFrameActionType;
import PluginReference.MC_ItemStack;
import PluginReference.MC_Location;
import PluginReference.MC_MiscGriefType;
import PluginReference.MC_Player;
import PluginReference.MC_PotionEffectType;
import PluginReference.MC_Projectile;
import PluginReference.MC_Server;
import PluginReference.MC_Sign;
import PluginReference.PluginInfo;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.List;
import java.util.UUID;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;

public abstract class PluginBase {
    private boolean initialized = false;
    private File dataFolder;
    private Configuration configuration = null;

    public final void init(File dataFolder) {
        Preconditions.checkState((!this.initialized ? 1 : 0) != 0, (Object)"Plugin instance already initialized.");
        this.initialized = true;
        this.dataFolder = dataFolder;
    }

    public final Configuration getConfig() {
        return this.getConfig(false);
    }

    public final Configuration getConfig(boolean saveDefaultConfig) {
        if (this.configuration != null) {
            return this.configuration;
        }
        return this.reloadConfig(saveDefaultConfig);
    }

    public final Configuration reloadConfig() {
        return this.reloadConfig(false);
    }

    public final Configuration reloadConfig(boolean saveDefaultConfig) {
        Preconditions.checkState((boolean)this.initialized, (Object)"Plugin instance not initialized yet.");
        File configFile = new File(this.dataFolder, "config.yml");
        if (!configFile.exists() && saveDefaultConfig) {
            try {
                Files.createParentDirs((File)configFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            InputStream defaultConfigStream = this.getClass().getClassLoader().getResourceAsStream("config.yml");
            if (defaultConfigStream != null) {
                try {
                    ByteStreams.copy((InputStream)defaultConfigStream, (OutputStream)new FileOutputStream(configFile));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                System.err.println("saveDefaultConfig enabled but no default config provided.");
            }
        }
        Configuration defaultConfig = null;
        InputStream defaultConfigStream = this.getClass().getClassLoader().getResourceAsStream("config.yml");
        if (defaultConfigStream != null) {
            defaultConfig = ConfigurationProvider.getProvider(YamlConfiguration.class).load(defaultConfigStream);
        }
        if (configFile.exists()) {
            try {
                this.configuration = ConfigurationProvider.getProvider(YamlConfiguration.class).load(configFile, defaultConfig);
                return this.configuration;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.configuration = defaultConfig;
        return this.configuration;
    }

    public final void saveConfig() {
        Preconditions.checkState((boolean)this.initialized, (Object)"Plugin instance not initialized yet.");
        File configFile = new File(this.dataFolder, "config.yml");
        if (!configFile.exists()) {
            try {
                Files.createParentDirs((File)configFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            ConfigurationProvider.getProvider(YamlConfiguration.class).save(this.configuration, configFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void onStartup(MC_Server argServer) {
    }

    public void onShutdown() {
    }

    public void onTick(int tickNumber) {
    }

    @Deprecated
    public /* synthetic */ void onPlayerLogin(String playerName, UUID uuid, String ip) {
    }

    public void onPlayerLogin(String playerName, UUID uuid, InetAddress address, MC_EventInfo ei) {
    }

    public void onPlayerLogout(String playerName, UUID uuid) {
    }

    public void onInteracted(MC_Player plr, MC_Location loc, MC_ItemStack isHandItem) {
    }

    public void onItemPlaced(MC_Player plr, MC_Location loc, MC_ItemStack isHandItem, MC_Location locPlacedAgainst, MC_DirectionNESWUD dir) {
    }

    @Deprecated
    public /* synthetic */ void onBlockBroke(MC_Player plr, MC_Location loc, int blockKey) {
    }

    public void onBlockBroke(MC_Player plr, MC_Location loc, MC_Block blk) {
    }

    public void onPlayerDeath(MC_Player plrVictim, MC_Player plrKiller, MC_DamageType dmgType, String deathMsg) {
    }

    public void onPlayerRespawn(MC_Player plr) {
    }

    public void onPlayerInput(MC_Player plr, String msg, MC_EventInfo ei) {
    }

    public void onConsoleInput(String cmd, MC_EventInfo ei) {
    }

    public void onAttemptBlockBreak(MC_Player plr, MC_Location loc, MC_EventInfo ei) {
    }

    @Deprecated
    public /* synthetic */ void onAttemptPlaceOrInteract(MC_Player plr, MC_Location loc, MC_EventInfo ei, MC_DirectionNESWUD dir) {
    }

    public void onAttemptPlaceOrInteract(MC_Player plr, MC_Location loc, MC_DirectionNESWUD dir, MC_Hand hand, MC_EventInfo ei) {
    }

    public void onAttemptExplosion(MC_Location loc, MC_EventInfo ei) {
    }

    public boolean onAttemptExplodeSpecific(MC_Entity ent, List<MC_Location> locs) {
        return false;
    }

    public void onAttemptDamageHangingEntity(MC_Player plr, MC_Location loc, MC_HangingEntityType entType, MC_EventInfo ei) {
    }

    public void onAttemptItemFrameInteract(MC_Player plr, MC_Location loc, MC_ItemFrameActionType actionType, MC_EventInfo ei) {
    }

    public void onAttemptPotionEffect(MC_Player plr, MC_PotionEffectType potionType, MC_EventInfo ei) {
    }

    public void onAttemptPlayerTeleport(MC_Player plr, MC_Location loc, MC_EventInfo ei) {
    }

    public void onAttemptPlayerChangeDimension(MC_Player plr, int newDimension, MC_EventInfo ei) {
    }

    public void onAttemptItemDrop(MC_Player plr, MC_ItemStack is, MC_EventInfo ei) {
    }

    public void onAttemptAttackEntity(MC_Player plr, MC_Entity ent, MC_EventInfo ei) {
    }

    public void onAttemptEntityDamage(MC_Entity ent, MC_DamageType dmgType, double amt, MC_EventInfo ei) {
    }

    public void onGenerateWorldColumn(int x, int z, MC_GeneratedColumn data) {
    }

    public void onAttemptPistonAction(MC_Location loc, MC_DirectionNESWUD dir, MC_EventInfo ei) {
    }

    public void onAttemptBlockFlow(MC_Location loc, MC_Block blk, MC_EventInfo ei) {
    }

    public void onContainerOpen(MC_Player plr, List<MC_ItemStack> items, String internalClassName) {
    }

    public void onAttemptPlayerMove(MC_Player plr, MC_Location locFrom, MC_Location locTo, MC_EventInfo ei) {
    }

    public void onPacketSoundEffect(MC_Player plr, String soundName, MC_Location loc, MC_EventInfo ei) {
    }

    public void onPlayerJoin(MC_Player plr) {
    }

    public void onSignChanging(MC_Player plr, MC_Sign sign, MC_Location loc, List<String> newLines, MC_EventInfo ei) {
    }

    public void onSignChanged(MC_Player plr, MC_Sign sign, MC_Location loc) {
    }

    public PluginInfo getPluginInfo() {
        return null;
    }

    public void onAttemptEntitySpawn(MC_Entity ent, MC_EventInfo ei) {
    }

    public void onServerFullyLoaded() {
    }

    public void onAttemptHopperReceivingItem(MC_Location loc, MC_ItemStack is, boolean isMinecartHopper, MC_EventInfo ei) {
    }

    public void onAttemptBookChange(MC_Player plr, List<String> bookContent, MC_EventInfo ei) {
    }

    public void onAttemptCropTrample(MC_Entity ent, MC_Location loc, MC_EventInfo ei) {
    }

    public void onFallComplete(MC_Entity ent, float fallDistance, MC_Location loc, boolean isWaterLanding) {
    }

    public void onAttemptArmorStandInteract(MC_Player plr, MC_Entity entStand, MC_ArmorStandActionType actionType, MC_EventInfo ei) {
    }

    public void onNonPlayerEntityDeath(MC_Entity entVictim, MC_Entity entKiller, MC_DamageType dmgType) {
    }

    public void onAttemptItemUse(MC_Player plr, MC_ItemStack is, MC_EventInfo ei) {
    }

    public Boolean onRequestPermission(String playerKey, String permission) {
        return null;
    }

    public void onContainerClosed(MC_Player plr, MC_ContainerType containerType) {
    }

    public void onAttemptItemPickup(MC_Player plr, MC_ItemStack is, boolean isXpOrb, MC_EventInfo ei) {
    }

    public void onAttemptEntityInteract(MC_Player plr, MC_Entity ent, MC_EventInfo ei) {
    }

    public void onItemCrafted(MC_Player plr, MC_ItemStack isCraftedItem) {
    }

    public void onPlayerBedEnter(MC_Player plr, MC_Block blkBed, MC_Location locBed) {
    }

    public void onPlayerBedLeave(MC_Player plr, MC_Block blkBed, MC_Location locBed) {
    }

    public void onAttemptBlockPlace(MC_Player plr, MC_Location loc, MC_Block blk, MC_ItemStack isHandItem, MC_Location locPlacedAgainst, MC_DirectionNESWUD dir, MC_EventInfo ei) {
    }

    public void onAttemptDeath(MC_Entity entVictim, MC_Entity entKiller, MC_DamageType dmgType, float dmgAmount) {
    }

    public void onAttemptFishingReel(MC_Player plr, MC_ItemStack isCatch, MC_Entity entCatch, boolean groundCatch, MC_EventInfo ei) {
    }

    public void onAttemptEntityMiscGrief(MC_Entity ent, MC_Location loc, MC_MiscGriefType griefType, MC_EventInfo ei) {
    }

    public void onAttemptSpectateEntity(MC_Player plr, MC_Entity ent, MC_EventInfo ei) {
    }

    public void onAttemptDispense(MC_Location loc, int idxItem, MC_Container container, MC_EventInfo ei) {
    }

    public void onEntityPushed(MC_Entity entity, MC_Entity pushedEntity, MC_FloatTriplet velocity, MC_EventInfo ei) {
    }

    public void onAttemptProjectileHitEntity(MC_Projectile projectile, MC_Entity entity, MC_Location hitLocation, MC_EventInfo ei) {
    }

    public void onAttemptProjectileHitBlock(MC_Projectile projectile, MC_Location blockLocation, MC_DirectionNESWUD blockFaceHit, MC_Location hitLocation, MC_EventInfo ei) {
    }

    public void onPlayerKick(MC_Player player, String reason, MC_EventInfo ei) {
    }

    public void onPluginMessage(String channel, byte[] data, MC_Player player) {
    }
}

